
/*
 * This file was generated by the SOM Compiler.
 * FileName: wpobject.h.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emith: 1.11
 */

/*
 * 
 *  Module Header
 * 
 *  Module Name: WPOBJECT
 * 
 *  OS/2 Presentation Manager Workplace class definitions
 * 
 *  Copyright (c) International Business Machines Corporation 1991, 1992
 * 
 */


#ifndef wpobject_h
#define wpobject_h


/*
 * Passthru lines: File: "C.h", "before"
 */

   #define INCL_WINSTDCNR
   #include <pmstddlg.h>

      #ifndef M_WPObject
      #define M_WPObject SOMClass
      #endif
      #ifndef WPObject
      #define WPObject SOMAny
      #endif

      /* Object style flags (see wpSetStyle) */

      #define OBJSTYLE_NOMOVE          2
      #define OBJSTYLE_NOLINK          4
      #define OBJSTYLE_NOCOPY          8
      #define OBJSTYLE_NOTDEFAULTICON 16
      #define OBJSTYLE_TEMPLATE       32
      #define OBJSTYLE_NODELETE       64
      #define OBJSTYLE_NOPRINT       128
      #define OBJSTYLE_NODRAG        256
      #define OBJSTYLE_NOTVISIBLE    512
      #define OBJSTYLE_NOSETTINGS   1024
      #define OBJSTYLE_NORENAME     2048
      #define OBJSTYLE_NODROP       4096

      /*  Class style flags (see wpclsQueryStyle) */

      #define CLSSTYLE_NEVERMOVE      OBJSTYLE_NOMOVE
      #define CLSSTYLE_NEVERLINK      OBJSTYLE_NOLINK
      #define CLSSTYLE_NEVERCOPY      OBJSTYLE_NOCOPY
      #define CLSSTYLE_NEVERTEMPLATE  16
      #define CLSSTYLE_NEVERDELETE    OBJSTYLE_NODELETE
      #define CLSSTYLE_NEVERPRINT     OBJSTYLE_NOPRINT
      #define CLSSTYLE_NEVERDRAG      OBJSTYLE_NODRAG
      #define CLSSTYLE_NEVERVISIBLE   OBJSTYLE_NOTVISIBLE
      #define CLSSTYLE_NEVERRENAME    OBJSTYLE_NORENAME
      #define CLSSTYLE_PRIVATE        4096

      /*  Flags for the wpFilterPopupMenu() method */

      #define CTXT_CRANOTHER     0x0001   /* Flags for ulFlags */
      #define CTXT_NEW           CTXT_CRANOTHER
      #define CTXT_OPEN          0x0002
      #define CTXT_WINDOW        0x0004
      #define CTXT_SWITCHTO      CTXT_WINDOW
      #define CTXT_CLOSE         0x0008
      #define CTXT_SETTINGS      0x0010
      #define CTXT_PRINT         0x0020
      #define CTXT_HELP          0x0040
      #define CTXT_DELETE        0x0080
      #define CTXT_COPY          0x0100
      #define CTXT_MOVE          0x0200
      #define CTXT_SHADOW        0x0400
      #define CTXT_LINK          CTXT_SHADOW
      #define CTXT_PROGRAM       0x0800
      #define CTXT_ICON        0x001000
      #define CTXT_TREE        0x002000
      #define CTXT_DETAILS     0x004000
      #define CTXT_FIND        0x008000
      #define CTXT_SELECT      0x010000
      #define CTXT_ARRANGE     0x020000
      #define CTXT_SORT        0x040000
      #define CTXT_SHUTDOWN    0x080000
      #define CTXT_LOCKUP      0x100000
      #define CTXT_PALETTE     0x200000
      #define CTXT_REFRESH     0x400000



      /* common context menu ids */

      #define WPMENUID_USER          0x6500
      #define WPMENUID_PRIMARY            0
      #define WPMENUID_OPEN               1
      #define WPMENUID_HELP               2
      #define WPMENUID_PRINT              3
      #define WPMENUID_SELECT     4
      #define WPMENUID_SORT       5


      /*  Open views for the wpOpen() method */

      #define OPEN_UNKNOWN      -1
      #define OPEN_DEFAULT       0
      #define OPEN_CONTENTS      1
      #define OPEN_SETTINGS      2
      #define OPEN_HELP          3
      #define OPEN_RUNNING       4
      #define OPEN_PROMPTDLG     5
      #define OPEN_PALETTE       121                                   /*SPLIT*/
      #define OPEN_USER          0x6500

      /*  Definitions for the INUSE list that is kept
       *  for every object via wpAddToObjUseList and
       *  wpRemoveFromObjUseList methods...
       */

      /* This structure is always followed immediately by a type
       * dependant struct such as MEMORYITEM,RECORDITEM,VIEWITEM
       * or some other user defined structure...
       */
      typedef struct _USEITEM
      {
         ULONG  type;                  /* Type of this Item */
         struct _USEITEM *pNext;   /* Next item in use list */
      } USEITEM;
      typedef USEITEM *PUSEITEM;

      #define USAGE_MEMORY          1  /* Values of 'type' */
      #define USAGE_RECORD          4
      #define USAGE_OPENVIEW        5
      #define USAGE_LINK            6
      #define USAGE_OPENFILE       20

      typedef struct _MEMORYITEM       /* USAGE_MEMORY struct */
      {
         ULONG     cbBuffer;           /* Number of bytes in memory block */
      } MEMORYITEM;
      typedef MEMORYITEM *PMEMORYITEM;

      typedef struct _RECORDITEM       /* USAGE_RECORD struct */
      {
         HWND            hwndCnr;      /* Cnr into which object is inserted */
         PMINIRECORDCORE pRecord;      /* Record pointer within that cnr */
         ULONG           ulUser;       /* For application use */         //RECSH
      } RECORDITEM;
      typedef RECORDITEM *PRECORDITEM;

      #define VIEWSTATE_OPENING       0x0001   /* The view is being opened */
      #define VIEWSTATE_OBJECTDELETED 0x0002   /* The object is being deleted */
      #define VIEWSTATE_USERHIDDEN    0x0004   /* The view was hidden by user */
      #define VIEWSTATE_POPULATING    0x0008   /* The view is populating      */

      typedef struct _VIEWITEM         /* USAGE_OPENVIEW struct */
      {
         ULONG        view;            /* Object view that this represents */
         LHANDLE      handle;          /* Open handle */
         ULONG        ulViewState;     /* View State flags */
         HWND         hwndCnr;         /* System use only (window animation) */
         PMINIRECORDCORE pRecord;      /* System use only (window animation) */
      } VIEWITEM;
      typedef VIEWITEM *PVIEWITEM;

      typedef struct _LINKITEM         /* USAGE_LINK struct */
      {
         WPObject    *LinkObj;         /* The link object */
      } LINKITEM;
      typedef LINKITEM *PLINKITEM;

      typedef struct _VIEWFILE         /* USAGE_OPENFILE struct */
      {
         ULONG        ulMenuId;        /* Menu id if association or menu page */
         LHANDLE      handle;          /* Open handle */
         HWND         hwndCnr;         /* System use only (window animation) */
         PMINIRECORDCORE pRecord;      /* System use only (window animation) */
      } VIEWFILE;
      typedef VIEWFILE *PVIEWFILE;

      /* Notes: The class name immediately follows the control block. The
       *        first instance variable control block immediately follows
       *        this.
       */
      typedef struct _WPSRCLASSBLOCK
      {
        SHORT   ClassNameLength;       /* Length of class name, including the
                                        * .. null terminator. This must be a
                                        * .. SHORT and must be at the beginning
                                        * .. of the structure.
                                        */
        USHORT  IVarLength;            /* Length of instance variable
                                        * .. information, including the two-
                                        * .. byte null terminator
                                        */
      } WPSRCLASSBLOCK;

      /*  Persistant storage structures (see wpSaveShort
       *  and wpRestoreShort etc...)
       */


      /* This control structure does not reside in the dormant state.
       * It is used only when a persistant data block is
       * resident in memory - either when an object is being saved or
       * when it is being restored...
       */
      typedef struct _OBJDATA
      {
         WPSRCLASSBLOCK       *CurrentClass;
         WPSRCLASSBLOCK       *First;
         PUCHAR                NextData;
         USHORT                Length;
      } OBJDATA;
      typedef OBJDATA *POBJDATA;

      /*  wpCnrInsertObject/wpCnrRemoveObject structs
       *  and macros...
       */

      typedef struct _CLASSDETAILS     /* Class Details struct */
      {
         PSZ          pszAttribute;    /* Translatable string for a class attribute*/
         PVOID        pSortRecord;     /* Function pointer for sort function for attribute*/
         struct _CLASSDETAILS *pNext; /* Next item in class details list */
      } CLASSDETAILS;
      typedef CLASSDETAILS *PCLASSDETAILS;

      /* Macro to return the object associated with a given MINIRECORDCORE
       * that was inserted using the wpCnrInsertObject method
       */
      #define OBJECT_FROM_PREC( prec )   ( (PVOID)( * (((PULONG)prec)-2) ) )

      /* Macro to access the app defineable dword within the RECORDITEM
       * structure that is created when an object is put into a list
       * control using the wpCnrInsertObject method.
       */
      PULONG EXPENTRY ShlGetUserWordPtr(
         HWND            hwndCnr,
         PMINIRECORDCORE prec );

      #define USERWORD_FROM_PREC( hwnd, prec )              \
         ( (ULONG)( *ShlGetUserWordPtr(hwnd,prec) ) )

      /* Details comparison function definition
       *
       *    Param1  PVOID   - Pointer to details field value
       *    Param2  PVOID   - Pointer to value to be compared with
       *
       *    Returns LONG    - Must be CMP_EQUAL, CMP_GREATER, CMP_LESS
       */
      typedef LONG (EXPENTRY FNCOMPARE)(PVOID,PVOID);
      typedef FNCOMPARE *PFNCOMPARE;

      #define CMP_EQUAL            0
      #define CMP_GREATER          1
      #define CMP_LESS             2
      #define CMP_GREATER_OR_EQUAL 3
      #define CMP_LESS_OR_EQUAL    4
      #define CMP_NOT_EQUAL        5

      #define NUM_CMP_VALUES       6

      /* Owner draw function definition
       *
       *    Param1  HWND  - Handle of window that is being painted
       *    Param2  PVOID - POWNERITEM structure pointer, see the container
       *                    control programming reference for the meaning
       *                    of the fields in this structure.
       *    Param3  PVOID - Pointer to the comparison value to draw (this
       *                    is NULL, except when this function is painting
       *                    its value into the include criteria dialog
       *                    when it points to Criteria.CompareValue...)
       *
       *    Returns BOOL  - TRUE if the field was ownerdrawn, FALSE if the
       *                    container control should do default painting.
       */
      typedef BOOL (EXPENTRY FNOWNDRW)(HWND,PVOID,PVOID);
      typedef FNOWNDRW *PFNOWNDRW;

      /* Details comparison criteria structure
       */
      typedef struct _CRITERIA
      {
         PVOID            pReserved;           /* Reserved - MUST be null!!!! */
         struct _CRITERIA *pNext;
         struct _CRITERIA *pPrev;
         ULONG            ClassFieldInfoIndex; /* Index of the details field  */
         ULONG            LogicalOperator;     /* CRITERIA_AND or CRITERIA_OR */
         ULONG            ComparisonType;      /* CMP_LESS_OR_EQUAL etc...    */
         ULONG            ulLenCompareValue;   /* sizeof(ComparisonData)      */
         CHAR             CompareValue[1];     /* Value to be compared with   */
      } CRITERIA;
      typedef CRITERIA *PCRITERIA;

      #define CRITERIA_AND        0
      #define CRITERIA_OR         1

      /* ClassCriteria structure: points to a linked list of CRITERIA
       * for the given class. ClassCriteria may be linked into a list
       * too - and passed to a filter object, or the wpclsFindObjectFirst
       * method call...
       */
      typedef struct _CLASSCRITERIA                                     /*!INC*/
      {
         struct _CLASSCRITERIA *pNext;
         struct _CLASSCRITERIA *pPrev;
         M_WPObject            *Class;          /* Class object */
         PCRITERIA              pCriteria;      /* Linked list of criteria */
         WPObject              *NotifyObject;   /* Owner of the criteria list */
      } CLASSCRITERIA;
      typedef CLASSCRITERIA *PCLASSCRITERIA;

      /* This structure is passed to a details criteria edit window
       * when it is created, so that it knows the current value and
       * min/max values for the criteria to be edited.
       *
       * As the user modifies the compare value using the criteria
       * edit window, it should update the buffer pointed to by
       * 'pCompareValue'.
       */
      typedef struct _EDITCTLINIT                                       /*!INC*/
      {
         ULONG cb;                /* must have length in control data! MindyP */
         PVOID pCompareValue;     /* Buffer containing the current value */
         ULONG ulLenCompareValue; /* Length of pCompareValue buffer */
         PVOID pMinCompareValue;  /* READ-ONLY parameter, NULL => default */
         PVOID pMaxCompareValue;  /* READ-ONLY parameter, NULL => default */
      } EDITCTLINIT;
      typedef EDITCTLINIT *PEDITCTLINIT;

      /* Structure for wpclsQueryDetailsInfo method
       *
       * CLASSFIELDINFO is identical to the FIELDINFO structure of the
       * container control with the following differences:
       *
       * - The offStruct field from FIELDINFO is reserved.
       * - The offFieldData and usLenFieldData structure elements have
       *   been added.
       * - Compare/Sort/Ownerdraw fields have also been added for the
       *   convenience of the programmer, so that object details can
       *   be customized and objects can be found or included by any
       *   of their displayable object details.
       *
       * For example if the application has the following details data:
       *
       * typedef struct _SAMPLE {
       *   CDATE   cdate;
       *   CTIME   ctime;
       *   PSZ     psz;
       * }  SAMPLE;
       *
       * classfieldinfo[0].offFieldData   = FIELDOFFSET(SAMPLE,cdate);
       * classfieldinfo[0].ulLenFieldData = FIELDOFFSET(SAMPLE,ctime) -
       *                                    FIELDOFFSET(SAMPLE,cdate);
       *
       * classfieldinfo[1].offFieldData   = FIELDOFFSET(SAMPLE,ctime);
       * classfieldinfo[1].ulLenFieldData = FIELDOFFSET(SAMPLE,psz) -
       *                                    FIELDOFFSET(SAMPLE,ctime);
       *
       * classfieldinfo[2].offFieldData   = FIELDOFFSET(SAMPLE,psz);
       * classfieldinfo[2].ulLenFieldData = sizeof(SAMPLE) -
       *                                    FIELDOFFSET(SAMPLE,psz);
       *
       * NOTE: It is essential that the fields be linked in order ex. above
       *       cdate must be followed by ctime and finally psz.
       */
      typedef struct _CLASSFIELDINFO                                    /*!INC*/
      {
         /* Details field attributes
          */
         ULONG      cb;                  /* size of CLASSFIELDINFO struct  */
         ULONG      flData;              /* attributes of field's data     */
         ULONG      flTitle;             /* attributes of field's title    */
         PVOID      pTitleData;          /* title data (default is string) */
                                         /* If CFT_BITMAP, must be HBITMAP */
         ULONG      ulReserved;          /* Reserved                       */
         PVOID      pUserData;           /* pointer to user data           */
         struct _CLASSFIELDINFO *pNextFieldInfo; /* pointer to next linked */
                                                /* CLASSFIELDINFO structure*/
         ULONG      cxWidth;             /* width of field in pels         */
         ULONG      offFieldData;        /* offset from beginning of       */
                                         /*   this class's data for this   */
                                         /*   field. (first field is 0).   */
         ULONG      ulLenFieldData;      /* width of data in bytes.        */
                                         /*   (4 for a pointer).           */
         PFNOWNDRW  pfnOwnerDraw;        /* Ownerdraw procedure for detail */
                                         /* column. Can be NULL except if  */
                                         /* ownerdraw is being used.       */
         /* Include/Sort parameters
          */
         ULONG      flCompare;           /* Flags: for example, use the    */
                                         /*   COMPARE_SUPPORTED flag if    */
                                         /*   your field can be compared   */
         PFNCOMPARE pfnCompare;          /* Comparison function for this   */
                                         /*   field. Can be NULL unless    */
                                         /*   ownerdraw is used.           */
         ULONG      DefaultComparison;   /* This is the default compare    */
                                         /*   operator in the include      */
                                         /*   page criteria dialog. (eg:   */
                                         /*   CMP_LESS_OR_EQUAL)           */
         ULONG      ulLenCompareValue;   /* Maximum length of the compare  */
                                         /*   data. Can be NULL unless     */
                                         /*   ownerdraw is used.           */
         PVOID      pDefCompareValue;    /* The default value to be used   */
                                         /*   for comparisons. Can be NULL */
                                         /*   unless ownerdraw is used.    */
         PVOID      pMinCompareValue;    /* The default value to be used   */
                                         /*   for comparisons.Can be NULL  */
                                         /*   unless ownerdraw is used.    */
         PVOID      pMaxCompareValue;    /* The default value to be used   */
                                         /*   for comparisons.Can be NULL  */
                                         /*   unless ownerdraw is used.    */
         PSZ        pszEditControlClass; /* Window class to be used to edit*/
                                         /*   the compare value. Can be    */
                                         /*   NULL unless ownerdraw is used*/
         PFNCOMPARE pfnSort;             /* Sort function for this @SM09511*/
                                         /*   field. Can be NULL unless    */
                                         /*   ownerdraw is used.           */
      } CLASSFIELDINFO;

      typedef CLASSFIELDINFO *PCLASSFIELDINFO;

      #define COMPARE_SUPPORTED      1
      #define SORTBY_SUPPORTED       2

      /* Standard notebook size constants */
      #define STDNOTEBOOKWIDTH    290
      #define STDNOTEBOOKHEIGHT   275

      /* Confirm flags */
      #define CONFIRM_DELETE        0x0001
      #define CONFIRM_DELETEFOLDER  0x0002
      #define CONFIRM_RENAMEFILESWITHEXT 0x0004
      #define CONFIRM_KEEPASSOC          0x0008
      #define CONFIRM_ACTION        0x0010
      #define CONFIRM_PROGRESS      0x0020

      #define OK_DELETE             1
      #define NO_DELETE             2
      #define CANCEL_DELETE         3

      #define NUM_OBJDETAILS_FIELDS    2     /* number of object details */

      /* Search Type for wpclsQueryExtendedCriteria */

      #define SEARCH_ALL_FOLDERS 1
      #define SEARCH_THIS_FOLDER 2
      #define SEARCH_THIS_TREE   3

      /* Find method related types and constants */

      typedef WPObject   *OBJECT;                             /* FIND */
      typedef OBJECT     *POBJECT;
      typedef M_WPObject *CLASS;
      typedef CLASS      *PCLASS;
      typedef LHANDLE     HFIND;
      typedef HFIND      *PHFIND;

      /* wpDrop method return code  */

      #define RC_DROP_DROPCOMPLETE 2
      #define RC_DROP_ITEMCOMPLETE 1
      #define RC_DROP_RENDERING    0
      #define RC_DROP_ERROR       -1

      /*handle for files being tracked by the shell */

      typedef LHANDLE HFS;
      #define MAXSZHFS 10       /* size of the translated string */

    #define SETTINGS_PAGE_REMOVED  -1

    /* wpSetConcurrentView values */
      #define CCVIEW_DEFAULT 0
      #define CCVIEW_ON      1
      #define CCVIEW_OFF     2

    /* wpSetMinWindow values */
      #define MINWIN_DEFAULT 0
      #define MINWIN_HIDDEN  1
      #define MINWIN_VIEWER  2
      #define MINWIN_DESKTOP 3

    /* wpSetButtonAppearance values */
      #define HIDEBUTTON      1
      #define MINBUTTON      2
      #define DEFAULTBUTTON  3

      #define  HIDDENMINWINDOW_DEFAULT MINWIN_VIEWER
      #define WPFolder SOMAny     /* Define WPFolder */

      typedef struct _TASKREC
      {
         struct _TASKREC *next;     /* next in the list of current tasks   */
         ULONG            useCount; /* can be referenced by multiple object*/
         PVOID            pStdDlg;  /* ptr to standard WP task dialog      */
         WPFolder        *folder;   /* intended folder for the object      */
         LONG             xOrigin;  /* intended position for the object    */
         LONG             yOrigin;  /* intended position for the object    */
         PSZ              pszTitle; /* intended name for the object        */
         ULONG            cbTitle;  /* length of the name buffer           */
         PMINIRECORDCORE  positionAfterRecord; /* intended sort position   */
         BOOL            fKeepAssociations;
         PVOID            pReserved;    /* reserved - equal null           */

      }  TASKREC;
      typedef TASKREC *PTASKREC;


#include <som.h>

/*
 * Define the class name as an object type
 */
#ifndef WPObject
#define WPObject SOMAny
#endif
#include <somobj.h>

#define WPObject_MajorVersion 1
#define WPObject_MinorVersion 2

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define WPObjectNewClass wpobjc
#pragma linkage(wpobjc, system)
#define WPObjectClassData wpobjd
#define WPObjectCClassData wpobjx
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */
/*--------------Migration------------*/
#define WPObject_classObj WPObjectClassData.classObject
#define _WPObject WPObject_classObj

/*
 * New and Renew macros for WPObject
 */
#define _WPObjectNew() (_somNew(WPObjectClassData.classObject))
#define WPObjectNew() \
	( WPObjectClassData.classObject \
		? _WPObjectNew() \
		: ( WPObjectNewClass(WPObject_MajorVersion, WPObject_MinorVersion), _WPObjectNew() ) )
#define WPObjectRenew(buf) \
	( _somRenew(WPObjectClassData.classObject, buf) )

/*
 * Override method: somInit
 */
#define WPObject_somInit(somSelf) \
	SOMObject_somInit(somSelf)

/*
 * Override method: somUninit
 */
#define WPObject_somUninit(somSelf) \
	SOMObject_somUninit(somSelf)

/*
 * New Method: wpAddObjectGeneralPage
 */
typedef ULONG    SOMLINK somTP_WPObject_wpAddObjectGeneralPage(WPObject *somSelf,
		HWND hwndNotebook);
#pragma linkage(somTP_WPObject_wpAddObjectGeneralPage, system)
typedef somTP_WPObject_wpAddObjectGeneralPage *somTD_WPObject_wpAddObjectGeneralPage;
#define somMD_WPObject_wpAddObjectGeneralPage "----"
#define WPObject_wpAddObjectGeneralPage(somSelf,hwndNotebook) \
    (SOM_Resolve(somSelf, WPObject, wpAddObjectGeneralPage) \
	(somSelf,hwndNotebook))
#define _wpAddObjectGeneralPage WPObject_wpAddObjectGeneralPage

/*
 * New Method: wpAddObjectWindowPage
 */
typedef ULONG    SOMLINK somTP_WPObject_wpAddObjectWindowPage(WPObject *somSelf,
		HWND hwndNotebook);
#pragma linkage(somTP_WPObject_wpAddObjectWindowPage, system)
typedef somTP_WPObject_wpAddObjectWindowPage *somTD_WPObject_wpAddObjectWindowPage;
#define somMD_WPObject_wpAddObjectWindowPage "----"
#define WPObject_wpAddObjectWindowPage(somSelf,hwndNotebook) \
    (SOM_Resolve(somSelf, WPObject, wpAddObjectWindowPage) \
	(somSelf,hwndNotebook))
#define _wpAddObjectWindowPage WPObject_wpAddObjectWindowPage

/*
 * New Method: wpAddSettingsPages
 */
typedef BOOL    SOMLINK somTP_WPObject_wpAddSettingsPages(WPObject *somSelf,
		HWND hwndNotebook);
#pragma linkage(somTP_WPObject_wpAddSettingsPages, system)
typedef somTP_WPObject_wpAddSettingsPages *somTD_WPObject_wpAddSettingsPages;
#define somMD_WPObject_wpAddSettingsPages "----"
#define WPObject_wpAddSettingsPages(somSelf,hwndNotebook) \
    (SOM_Resolve(somSelf, WPObject, wpAddSettingsPages) \
	(somSelf,hwndNotebook))
#define _wpAddSettingsPages WPObject_wpAddSettingsPages

/*
 * New Method: wpAddToObjUseList
 */
typedef BOOL    SOMLINK somTP_WPObject_wpAddToObjUseList(WPObject *somSelf,
		PUSEITEM pUseItem);
#pragma linkage(somTP_WPObject_wpAddToObjUseList, system)
typedef somTP_WPObject_wpAddToObjUseList *somTD_WPObject_wpAddToObjUseList;
#define somMD_WPObject_wpAddToObjUseList "----"
#define WPObject_wpAddToObjUseList(somSelf,pUseItem) \
    (SOM_Resolve(somSelf, WPObject, wpAddToObjUseList) \
	(somSelf,pUseItem))
#define _wpAddToObjUseList WPObject_wpAddToObjUseList

/*
 * New Method: wpAllocMem
 */
typedef PBYTE    SOMLINK somTP_WPObject_wpAllocMem(WPObject *somSelf,
		ULONG cbBytes,
		PULONG prc);
#pragma linkage(somTP_WPObject_wpAllocMem, system)
typedef somTP_WPObject_wpAllocMem *somTD_WPObject_wpAllocMem;
#define somMD_WPObject_wpAllocMem "----"
#define WPObject_wpAllocMem(somSelf,cbBytes,prc) \
    (SOM_Resolve(somSelf, WPObject, wpAllocMem) \
	(somSelf,cbBytes,prc))
#define _wpAllocMem WPObject_wpAllocMem

/*
 * New Method: wpAppendObject
 */
typedef BOOL32    SOMLINK somTP_WPObject_wpAppendObject(WPObject *somSelf,
		WPObject *targetObject,
		BOOL32 fMove);
#pragma linkage(somTP_WPObject_wpAppendObject, system)
typedef somTP_WPObject_wpAppendObject *somTD_WPObject_wpAppendObject;
#define somMD_WPObject_wpAppendObject "----"
#define WPObject_wpAppendObject(somSelf,targetObject,fMove) \
    (SOM_Resolve(somSelf, WPObject, wpAppendObject) \
	(somSelf,targetObject,fMove))
#define _wpAppendObject WPObject_wpAppendObject

/*
 * New Method: wpAssertObjectMutexSem
 */
typedef BOOL    SOMLINK somTP_WPObject_wpAssertObjectMutexSem(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpAssertObjectMutexSem, system)
typedef somTP_WPObject_wpAssertObjectMutexSem *somTD_WPObject_wpAssertObjectMutexSem;
#define somMD_WPObject_wpAssertObjectMutexSem "----"
#define WPObject_wpAssertObjectMutexSem(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpAssertObjectMutexSem) \
	(somSelf))
#define _wpAssertObjectMutexSem WPObject_wpAssertObjectMutexSem

/*
 * New Method: wpClose
 */
typedef BOOL    SOMLINK somTP_WPObject_wpClose(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpClose, system)
typedef somTP_WPObject_wpClose *somTD_WPObject_wpClose;
#define somMD_WPObject_wpClose "----"
#define WPObject_wpClose(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpClose) \
	(somSelf))
#define _wpClose WPObject_wpClose

/*
 * New Method: wpCnrInsertObject
 */
typedef PMINIRECORDCORE    SOMLINK somTP_WPObject_wpCnrInsertObject(WPObject *somSelf,
		HWND hwndCnr,
		PPOINTL pptlIcon,
		PMINIRECORDCORE preccParent,
		PRECORDINSERT pRecInsert);
#pragma linkage(somTP_WPObject_wpCnrInsertObject, system)
typedef somTP_WPObject_wpCnrInsertObject *somTD_WPObject_wpCnrInsertObject;
#define somMD_WPObject_wpCnrInsertObject "----"
#define WPObject_wpCnrInsertObject(somSelf,hwndCnr,pptlIcon,preccParent,pRecInsert) \
    (SOM_Resolve(somSelf, WPObject, wpCnrInsertObject) \
	(somSelf,hwndCnr,pptlIcon,preccParent,pRecInsert))
#define _wpCnrInsertObject WPObject_wpCnrInsertObject

/*
 * New Method: wpCnrRemoveObject
 */
typedef BOOL    SOMLINK somTP_WPObject_wpCnrRemoveObject(WPObject *somSelf,
		HWND hwndCnr);
#pragma linkage(somTP_WPObject_wpCnrRemoveObject, system)
typedef somTP_WPObject_wpCnrRemoveObject *somTD_WPObject_wpCnrRemoveObject;
#define somMD_WPObject_wpCnrRemoveObject "----"
#define WPObject_wpCnrRemoveObject(somSelf,hwndCnr) \
    (SOM_Resolve(somSelf, WPObject, wpCnrRemoveObject) \
	(somSelf,hwndCnr))
#define _wpCnrRemoveObject WPObject_wpCnrRemoveObject

/*
 * New Method: wpCnrSetEmphasis
 */
typedef BOOL    SOMLINK somTP_WPObject_wpCnrSetEmphasis(WPObject *somSelf,
		ULONG ulEmphasisAttr,
		BOOL fTurnOn);
#pragma linkage(somTP_WPObject_wpCnrSetEmphasis, system)
typedef somTP_WPObject_wpCnrSetEmphasis *somTD_WPObject_wpCnrSetEmphasis;
#define somMD_WPObject_wpCnrSetEmphasis "----"
#define WPObject_wpCnrSetEmphasis(somSelf,ulEmphasisAttr,fTurnOn) \
    (SOM_Resolve(somSelf, WPObject, wpCnrSetEmphasis) \
	(somSelf,ulEmphasisAttr,fTurnOn))
#define _wpCnrSetEmphasis WPObject_wpCnrSetEmphasis

/*
 * New Method: wpConfirmDelete
 */
typedef ULONG    SOMLINK somTP_WPObject_wpConfirmDelete(WPObject *somSelf,
		ULONG fConfirmations);
#pragma linkage(somTP_WPObject_wpConfirmDelete, system)
typedef somTP_WPObject_wpConfirmDelete *somTD_WPObject_wpConfirmDelete;
#define somMD_WPObject_wpConfirmDelete "----"
#define WPObject_wpConfirmDelete(somSelf,fConfirmations) \
    (SOM_Resolve(somSelf, WPObject, wpConfirmDelete) \
	(somSelf,fConfirmations))
#define _wpConfirmDelete WPObject_wpConfirmDelete

/*
 * New Method: wpConfirmObjectTitle
 */
typedef ULONG    SOMLINK somTP_WPObject_wpConfirmObjectTitle(WPObject *somSelf,
		WPFolder *Folder,
		WPObject **ppDuplicate,
		PSZ pszTitle,
		ULONG cbTitle,
		ULONG menuID);
#pragma linkage(somTP_WPObject_wpConfirmObjectTitle, system)
typedef somTP_WPObject_wpConfirmObjectTitle *somTD_WPObject_wpConfirmObjectTitle;
#define somMD_WPObject_wpConfirmObjectTitle "----"
#define WPObject_wpConfirmObjectTitle(somSelf,Folder,ppDuplicate,pszTitle,cbTitle,menuID) \
    (SOM_Resolve(somSelf, WPObject, wpConfirmObjectTitle) \
	(somSelf,Folder,ppDuplicate,pszTitle,cbTitle,menuID))
#define _wpConfirmObjectTitle WPObject_wpConfirmObjectTitle

/*
 * New Method: wpCopiedFromTemplate
 */
typedef void    SOMLINK somTP_WPObject_wpCopiedFromTemplate(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpCopiedFromTemplate, system)
typedef somTP_WPObject_wpCopiedFromTemplate *somTD_WPObject_wpCopiedFromTemplate;
#define somMD_WPObject_wpCopiedFromTemplate "----"
#define WPObject_wpCopiedFromTemplate(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpCopiedFromTemplate) \
	(somSelf))
#define _wpCopiedFromTemplate WPObject_wpCopiedFromTemplate

/*
 * New Method: wpCopyObject
 */
typedef WPObject *   SOMLINK somTP_WPObject_wpCopyObject(WPObject *somSelf,
		WPFolder *Folder,
		BOOL fLock);
#pragma linkage(somTP_WPObject_wpCopyObject, system)
typedef somTP_WPObject_wpCopyObject *somTD_WPObject_wpCopyObject;
#define somMD_WPObject_wpCopyObject "----"
#define WPObject_wpCopyObject(somSelf,Folder,fLock) \
    (SOM_Resolve(somSelf, WPObject, wpCopyObject) \
	(somSelf,Folder,fLock))
#define _wpCopyObject WPObject_wpCopyObject

/*
 * New Method: wpCreateAnother
 */
typedef WPObject *   SOMLINK somTP_WPObject_wpCreateAnother(WPObject *somSelf,
		PSZ pszTitle,
		PSZ pszSetupEnv,
		WPFolder *Folder);
#pragma linkage(somTP_WPObject_wpCreateAnother, system)
typedef somTP_WPObject_wpCreateAnother *somTD_WPObject_wpCreateAnother;
#define somMD_WPObject_wpCreateAnother "----"
#define WPObject_wpCreateAnother(somSelf,pszTitle,pszSetupEnv,Folder) \
    (SOM_Resolve(somSelf, WPObject, wpCreateAnother) \
	(somSelf,pszTitle,pszSetupEnv,Folder))
#define _wpCreateAnother WPObject_wpCreateAnother

/*
 * New Method: wpCreateFromTemplate
 */
typedef WPObject *   SOMLINK somTP_WPObject_wpCreateFromTemplate(WPObject *somSelf,
		WPFolder *folder,
		BOOL fLock);
#pragma linkage(somTP_WPObject_wpCreateFromTemplate, system)
typedef somTP_WPObject_wpCreateFromTemplate *somTD_WPObject_wpCreateFromTemplate;
#define somMD_WPObject_wpCreateFromTemplate "----"
#define WPObject_wpCreateFromTemplate(somSelf,folder,fLock) \
    (SOM_Resolve(somSelf, WPObject, wpCreateFromTemplate) \
	(somSelf,folder,fLock))
#define _wpCreateFromTemplate WPObject_wpCreateFromTemplate

/*
 * New Method: wpCreateShadowObject
 */
typedef WPObject *   SOMLINK somTP_WPObject_wpCreateShadowObject(WPObject *somSelf,
		WPFolder *Folder,
		BOOL fLock);
#pragma linkage(somTP_WPObject_wpCreateShadowObject, system)
typedef somTP_WPObject_wpCreateShadowObject *somTD_WPObject_wpCreateShadowObject;
#define somMD_WPObject_wpCreateShadowObject "----"
#define WPObject_wpCreateShadowObject(somSelf,Folder,fLock) \
    (SOM_Resolve(somSelf, WPObject, wpCreateShadowObject) \
	(somSelf,Folder,fLock))
#define _wpCreateShadowObject WPObject_wpCreateShadowObject

/*
 * New Method: wpDelete
 */
typedef ULONG    SOMLINK somTP_WPObject_wpDelete(WPObject *somSelf,
		ULONG fConfirmations);
#pragma linkage(somTP_WPObject_wpDelete, system)
typedef somTP_WPObject_wpDelete *somTD_WPObject_wpDelete;
#define somMD_WPObject_wpDelete "----"
#define WPObject_wpDelete(somSelf,fConfirmations) \
    (SOM_Resolve(somSelf, WPObject, wpDelete) \
	(somSelf,fConfirmations))
#define _wpDelete WPObject_wpDelete

/*
 * New Method: wpDeleteFromObjUseList
 */
typedef BOOL    SOMLINK somTP_WPObject_wpDeleteFromObjUseList(WPObject *somSelf,
		PUSEITEM pUseItem);
#pragma linkage(somTP_WPObject_wpDeleteFromObjUseList, system)
typedef somTP_WPObject_wpDeleteFromObjUseList *somTD_WPObject_wpDeleteFromObjUseList;
#define somMD_WPObject_wpDeleteFromObjUseList "----"
#define WPObject_wpDeleteFromObjUseList(somSelf,pUseItem) \
    (SOM_Resolve(somSelf, WPObject, wpDeleteFromObjUseList) \
	(somSelf,pUseItem))
#define _wpDeleteFromObjUseList WPObject_wpDeleteFromObjUseList

/*
 * New Method: wpDisplayHelp
 */
typedef BOOL    SOMLINK somTP_WPObject_wpDisplayHelp(WPObject *somSelf,
		ULONG HelpPanelId,
		PSZ HelpLibrary);
#pragma linkage(somTP_WPObject_wpDisplayHelp, system)
typedef somTP_WPObject_wpDisplayHelp *somTD_WPObject_wpDisplayHelp;
#define somMD_WPObject_wpDisplayHelp "----"
#define WPObject_wpDisplayHelp(somSelf,HelpPanelId,HelpLibrary) \
    (SOM_Resolve(somSelf, WPObject, wpDisplayHelp) \
	(somSelf,HelpPanelId,HelpLibrary))
#define _wpDisplayHelp WPObject_wpDisplayHelp

/*
 * New Method: wpDoesObjectMatch
 */
typedef BOOL    SOMLINK somTP_WPObject_wpDoesObjectMatch(WPObject *somSelf,
		PVOID pvoidExtendedCriteria);
#pragma linkage(somTP_WPObject_wpDoesObjectMatch, system)
typedef somTP_WPObject_wpDoesObjectMatch *somTD_WPObject_wpDoesObjectMatch;
#define somMD_WPObject_wpDoesObjectMatch "----"
#define WPObject_wpDoesObjectMatch(somSelf,pvoidExtendedCriteria) \
    (SOM_Resolve(somSelf, WPObject, wpDoesObjectMatch) \
	(somSelf,pvoidExtendedCriteria))
#define _wpDoesObjectMatch WPObject_wpDoesObjectMatch

/*
 * New Method: wpDraggedOverObject
 */
typedef MRESULT    SOMLINK somTP_WPObject_wpDraggedOverObject(WPObject *somSelf,
		WPObject *DraggedOverObject);
#pragma linkage(somTP_WPObject_wpDraggedOverObject, system)
typedef somTP_WPObject_wpDraggedOverObject *somTD_WPObject_wpDraggedOverObject;
#define somMD_WPObject_wpDraggedOverObject "----"
#define WPObject_wpDraggedOverObject(somSelf,DraggedOverObject) \
    (SOM_Resolve(somSelf, WPObject, wpDraggedOverObject) \
	(somSelf,DraggedOverObject))
#define _wpDraggedOverObject WPObject_wpDraggedOverObject

/*
 * New Method: wpDragOver
 */
typedef MRESULT    SOMLINK somTP_WPObject_wpDragOver(WPObject *somSelf,
		HWND hwndCnr,
		PDRAGINFO pdrgInfo);
#pragma linkage(somTP_WPObject_wpDragOver, system)
typedef somTP_WPObject_wpDragOver *somTD_WPObject_wpDragOver;
#define somMD_WPObject_wpDragOver "----"
#define WPObject_wpDragOver(somSelf,hwndCnr,pdrgInfo) \
    (SOM_Resolve(somSelf, WPObject, wpDragOver) \
	(somSelf,hwndCnr,pdrgInfo))
#define _wpDragOver WPObject_wpDragOver

/*
 * New Method: wpDrop
 */
typedef MRESULT    SOMLINK somTP_WPObject_wpDrop(WPObject *somSelf,
		HWND hwndCnr,
		PDRAGINFO pdrgInfo,
		PDRAGITEM pdrgItem);
#pragma linkage(somTP_WPObject_wpDrop, system)
typedef somTP_WPObject_wpDrop *somTD_WPObject_wpDrop;
#define somMD_WPObject_wpDrop "----"
#define WPObject_wpDrop(somSelf,hwndCnr,pdrgInfo,pdrgItem) \
    (SOM_Resolve(somSelf, WPObject, wpDrop) \
	(somSelf,hwndCnr,pdrgInfo,pdrgItem))
#define _wpDrop WPObject_wpDrop

/*
 * New Method: wpDroppedOnObject
 */
typedef BOOL    SOMLINK somTP_WPObject_wpDroppedOnObject(WPObject *somSelf,
		WPObject *DroppedOnObject);
#pragma linkage(somTP_WPObject_wpDroppedOnObject, system)
typedef somTP_WPObject_wpDroppedOnObject *somTD_WPObject_wpDroppedOnObject;
#define somMD_WPObject_wpDroppedOnObject "----"
#define WPObject_wpDroppedOnObject(somSelf,DroppedOnObject) \
    (SOM_Resolve(somSelf, WPObject, wpDroppedOnObject) \
	(somSelf,DroppedOnObject))
#define _wpDroppedOnObject WPObject_wpDroppedOnObject

/*
 * New Method: wpEndConversation
 */
typedef MRESULT    SOMLINK somTP_WPObject_wpEndConversation(WPObject *somSelf,
		ULONG ulItemID,
		ULONG flResult);
#pragma linkage(somTP_WPObject_wpEndConversation, system)
typedef somTP_WPObject_wpEndConversation *somTD_WPObject_wpEndConversation;
#define somMD_WPObject_wpEndConversation "----"
#define WPObject_wpEndConversation(somSelf,ulItemID,flResult) \
    (SOM_Resolve(somSelf, WPObject, wpEndConversation) \
	(somSelf,ulItemID,flResult))
#define _wpEndConversation WPObject_wpEndConversation

/*
 * New Method: wpFilterPopupMenu
 */
typedef ULONG    SOMLINK somTP_WPObject_wpFilterPopupMenu(WPObject *somSelf,
		ULONG ulFlags,
		HWND hwndCnr,
		BOOL fMultiSelect);
#pragma linkage(somTP_WPObject_wpFilterPopupMenu, system)
typedef somTP_WPObject_wpFilterPopupMenu *somTD_WPObject_wpFilterPopupMenu;
#define somMD_WPObject_wpFilterPopupMenu "----"
#define WPObject_wpFilterPopupMenu(somSelf,ulFlags,hwndCnr,fMultiSelect) \
    (SOM_Resolve(somSelf, WPObject, wpFilterPopupMenu) \
	(somSelf,ulFlags,hwndCnr,fMultiSelect))
#define _wpFilterPopupMenu WPObject_wpFilterPopupMenu

/*
 * New Method: wpFindUseItem
 */
typedef PUSEITEM    SOMLINK somTP_WPObject_wpFindUseItem(WPObject *somSelf,
		ULONG type,
		PUSEITEM pCurrentItem);
#pragma linkage(somTP_WPObject_wpFindUseItem, system)
typedef somTP_WPObject_wpFindUseItem *somTD_WPObject_wpFindUseItem;
#define somMD_WPObject_wpFindUseItem "----"
#define WPObject_wpFindUseItem(somSelf,type,pCurrentItem) \
    (SOM_Resolve(somSelf, WPObject, wpFindUseItem) \
	(somSelf,type,pCurrentItem))
#define _wpFindUseItem WPObject_wpFindUseItem

/*
 * New Method: wpFormatDragItem
 */
typedef BOOL    SOMLINK somTP_WPObject_wpFormatDragItem(WPObject *somSelf,
		PDRAGITEM pdrgItem);
#pragma linkage(somTP_WPObject_wpFormatDragItem, system)
typedef somTP_WPObject_wpFormatDragItem *somTD_WPObject_wpFormatDragItem;
#define somMD_WPObject_wpFormatDragItem "----"
#define WPObject_wpFormatDragItem(somSelf,pdrgItem) \
    (SOM_Resolve(somSelf, WPObject, wpFormatDragItem) \
	(somSelf,pdrgItem))
#define _wpFormatDragItem WPObject_wpFormatDragItem

/*
 * New Method: wpFree
 */
typedef BOOL    SOMLINK somTP_WPObject_wpFree(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpFree, system)
typedef somTP_WPObject_wpFree *somTD_WPObject_wpFree;
#define somMD_WPObject_wpFree "----"
#define WPObject_wpFree(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpFree) \
	(somSelf))
#define _wpFree WPObject_wpFree

/*
 * New Method: wpFreeMem
 */
typedef BOOL    SOMLINK somTP_WPObject_wpFreeMem(WPObject *somSelf,
		PBYTE pByte);
#pragma linkage(somTP_WPObject_wpFreeMem, system)
typedef somTP_WPObject_wpFreeMem *somTD_WPObject_wpFreeMem;
#define somMD_WPObject_wpFreeMem "----"
#define WPObject_wpFreeMem(somSelf,pByte) \
    (SOM_Resolve(somSelf, WPObject, wpFreeMem) \
	(somSelf,pByte))
#define _wpFreeMem WPObject_wpFreeMem

/*
 * New Method: wpHide
 */
typedef BOOL    SOMLINK somTP_WPObject_wpHide(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpHide, system)
typedef somTP_WPObject_wpHide *somTD_WPObject_wpHide;
#define somMD_WPObject_wpHide "----"
#define WPObject_wpHide(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpHide) \
	(somSelf))
#define _wpHide WPObject_wpHide

/*
 * New Method: wpInitData
 */
typedef void    SOMLINK somTP_WPObject_wpInitData(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpInitData, system)
typedef somTP_WPObject_wpInitData *somTD_WPObject_wpInitData;
#define somMD_WPObject_wpInitData "----"
#define WPObject_wpInitData(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpInitData) \
	(somSelf))
#define _wpInitData WPObject_wpInitData

/*
 * New Method: wpInsertPopupMenuItems
 */
typedef BOOL    SOMLINK somTP_WPObject_wpInsertPopupMenuItems(WPObject *somSelf,
		HWND hwndMenu,
		ULONG iPosition,
		HMODULE hmod,
		ULONG MenuID,
		ULONG SubMenuID);
#pragma linkage(somTP_WPObject_wpInsertPopupMenuItems, system)
typedef somTP_WPObject_wpInsertPopupMenuItems *somTD_WPObject_wpInsertPopupMenuItems;
#define somMD_WPObject_wpInsertPopupMenuItems "----"
#define WPObject_wpInsertPopupMenuItems(somSelf,hwndMenu,iPosition,hmod,MenuID,SubMenuID) \
    (SOM_Resolve(somSelf, WPObject, wpInsertPopupMenuItems) \
	(somSelf,hwndMenu,iPosition,hmod,MenuID,SubMenuID))
#define _wpInsertPopupMenuItems WPObject_wpInsertPopupMenuItems

/*
 * New Method: wpInsertSettingsPage
 */
typedef ULONG    SOMLINK somTP_WPObject_wpInsertSettingsPage(WPObject *somSelf,
		HWND hwndNotebook,
		PPAGEINFO ppageinfo);
#pragma linkage(somTP_WPObject_wpInsertSettingsPage, system)
typedef somTP_WPObject_wpInsertSettingsPage *somTD_WPObject_wpInsertSettingsPage;
#define somMD_WPObject_wpInsertSettingsPage "----"
#define WPObject_wpInsertSettingsPage(somSelf,hwndNotebook,ppageinfo) \
    (SOM_Resolve(somSelf, WPObject, wpInsertSettingsPage) \
	(somSelf,hwndNotebook,ppageinfo))
#define _wpInsertSettingsPage WPObject_wpInsertSettingsPage

/*
 * New Method: wpMenuItemHelpSelected
 */
typedef BOOL    SOMLINK somTP_WPObject_wpMenuItemHelpSelected(WPObject *somSelf,
		ULONG MenuId);
#pragma linkage(somTP_WPObject_wpMenuItemHelpSelected, system)
typedef somTP_WPObject_wpMenuItemHelpSelected *somTD_WPObject_wpMenuItemHelpSelected;
#define somMD_WPObject_wpMenuItemHelpSelected "----"
#define WPObject_wpMenuItemHelpSelected(somSelf,MenuId) \
    (SOM_Resolve(somSelf, WPObject, wpMenuItemHelpSelected) \
	(somSelf,MenuId))
#define _wpMenuItemHelpSelected WPObject_wpMenuItemHelpSelected

/*
 * New Method: wpMenuItemSelected
 */
typedef BOOL    SOMLINK somTP_WPObject_wpMenuItemSelected(WPObject *somSelf,
		HWND hwndFrame,
		ULONG ulMenuId);
#pragma linkage(somTP_WPObject_wpMenuItemSelected, system)
typedef somTP_WPObject_wpMenuItemSelected *somTD_WPObject_wpMenuItemSelected;
#define somMD_WPObject_wpMenuItemSelected "----"
#define WPObject_wpMenuItemSelected(somSelf,hwndFrame,ulMenuId) \
    (SOM_Resolve(somSelf, WPObject, wpMenuItemSelected) \
	(somSelf,hwndFrame,ulMenuId))
#define _wpMenuItemSelected WPObject_wpMenuItemSelected

/*
 * New Method: wpModifyPopupMenu
 */
typedef BOOL    SOMLINK somTP_WPObject_wpModifyPopupMenu(WPObject *somSelf,
		HWND hwndMenu,
		HWND hwndCnr,
		ULONG iPosition);
#pragma linkage(somTP_WPObject_wpModifyPopupMenu, system)
typedef somTP_WPObject_wpModifyPopupMenu *somTD_WPObject_wpModifyPopupMenu;
#define somMD_WPObject_wpModifyPopupMenu "----"
#define WPObject_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition) \
    (SOM_Resolve(somSelf, WPObject, wpModifyPopupMenu) \
	(somSelf,hwndMenu,hwndCnr,iPosition))
#define _wpModifyPopupMenu WPObject_wpModifyPopupMenu

/*
 * New Method: wpMoveObject
 */
typedef BOOL    SOMLINK somTP_WPObject_wpMoveObject(WPObject *somSelf,
		WPFolder *Folder);
#pragma linkage(somTP_WPObject_wpMoveObject, system)
typedef somTP_WPObject_wpMoveObject *somTD_WPObject_wpMoveObject;
#define somMD_WPObject_wpMoveObject "----"
#define WPObject_wpMoveObject(somSelf,Folder) \
    (SOM_Resolve(somSelf, WPObject, wpMoveObject) \
	(somSelf,Folder))
#define _wpMoveObject WPObject_wpMoveObject

/*
 * New Method: wpOpen
 */
typedef HWND    SOMLINK somTP_WPObject_wpOpen(WPObject *somSelf,
		HWND hwndCnr,
		ULONG ulView,
		ULONG param);
#pragma linkage(somTP_WPObject_wpOpen, system)
typedef somTP_WPObject_wpOpen *somTD_WPObject_wpOpen;
#define somMD_WPObject_wpOpen "----"
#define WPObject_wpOpen(somSelf,hwndCnr,ulView,param) \
    (SOM_Resolve(somSelf, WPObject, wpOpen) \
	(somSelf,hwndCnr,ulView,param))
#define _wpOpen WPObject_wpOpen

/*
 * New Method: wpPrintObject
 */
typedef BOOL    SOMLINK somTP_WPObject_wpPrintObject(WPObject *somSelf,
		PPRINTDEST pPrintDest,
		ULONG ulReserved);
#pragma linkage(somTP_WPObject_wpPrintObject, system)
typedef somTP_WPObject_wpPrintObject *somTD_WPObject_wpPrintObject;
#define somMD_WPObject_wpPrintObject "----"
#define WPObject_wpPrintObject(somSelf,pPrintDest,ulReserved) \
    (SOM_Resolve(somSelf, WPObject, wpPrintObject) \
	(somSelf,pPrintDest,ulReserved))
#define _wpPrintObject WPObject_wpPrintObject

/*
 * New Method: wpQueryConcurrentView
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryConcurrentView(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryConcurrentView, system)
typedef somTP_WPObject_wpQueryConcurrentView *somTD_WPObject_wpQueryConcurrentView;
#define somMD_WPObject_wpQueryConcurrentView "----"
#define WPObject_wpQueryConcurrentView(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryConcurrentView) \
	(somSelf))
#define _wpQueryConcurrentView WPObject_wpQueryConcurrentView

/*
 * New Method: wpQueryButtonAppearance
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryButtonAppearance(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryButtonAppearance, system)
typedef somTP_WPObject_wpQueryButtonAppearance *somTD_WPObject_wpQueryButtonAppearance;
#define somMD_WPObject_wpQueryButtonAppearance "----"
#define WPObject_wpQueryButtonAppearance(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryButtonAppearance) \
	(somSelf))
#define _wpQueryButtonAppearance WPObject_wpQueryButtonAppearance

/*
 * New Method: wpQueryConfirmations
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryConfirmations(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryConfirmations, system)
typedef somTP_WPObject_wpQueryConfirmations *somTD_WPObject_wpQueryConfirmations;
#define somMD_WPObject_wpQueryConfirmations "----"
#define WPObject_wpQueryConfirmations(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryConfirmations) \
	(somSelf))
#define _wpQueryConfirmations WPObject_wpQueryConfirmations

/*
 * New Method: wpQueryDefaultHelp
 */
typedef BOOL    SOMLINK somTP_WPObject_wpQueryDefaultHelp(WPObject *somSelf,
		PULONG pHelpPanelId,
		PSZ HelpLibrary);
#pragma linkage(somTP_WPObject_wpQueryDefaultHelp, system)
typedef somTP_WPObject_wpQueryDefaultHelp *somTD_WPObject_wpQueryDefaultHelp;
#define somMD_WPObject_wpQueryDefaultHelp "----"
#define WPObject_wpQueryDefaultHelp(somSelf,pHelpPanelId,HelpLibrary) \
    (SOM_Resolve(somSelf, WPObject, wpQueryDefaultHelp) \
	(somSelf,pHelpPanelId,HelpLibrary))
#define _wpQueryDefaultHelp WPObject_wpQueryDefaultHelp

/*
 * New Method: wpQueryDefaultView
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryDefaultView(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryDefaultView, system)
typedef somTP_WPObject_wpQueryDefaultView *somTD_WPObject_wpQueryDefaultView;
#define somMD_WPObject_wpQueryDefaultView "----"
#define WPObject_wpQueryDefaultView(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryDefaultView) \
	(somSelf))
#define _wpQueryDefaultView WPObject_wpQueryDefaultView

/*
 * New Method: wpQueryDetailsData
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryDetailsData(WPObject *somSelf,
		PVOID *ppDetailsData,
		PULONG pcp);
#pragma linkage(somTP_WPObject_wpQueryDetailsData, system)
typedef somTP_WPObject_wpQueryDetailsData *somTD_WPObject_wpQueryDetailsData;
#define somMD_WPObject_wpQueryDetailsData "----"
#define WPObject_wpQueryDetailsData(somSelf,ppDetailsData,pcp) \
    (SOM_Resolve(somSelf, WPObject, wpQueryDetailsData) \
	(somSelf,ppDetailsData,pcp))
#define _wpQueryDetailsData WPObject_wpQueryDetailsData

/*
 * New Method: wpQueryError
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryError(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryError, system)
typedef somTP_WPObject_wpQueryError *somTD_WPObject_wpQueryError;
#define somMD_WPObject_wpQueryError "----"
#define WPObject_wpQueryError(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryError) \
	(somSelf))
#define _wpQueryError WPObject_wpQueryError

/*
 * New Method: wpQueryIcon
 */
typedef HPOINTER    SOMLINK somTP_WPObject_wpQueryIcon(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryIcon, system)
typedef somTP_WPObject_wpQueryIcon *somTD_WPObject_wpQueryIcon;
#define somMD_WPObject_wpQueryIcon "----"
#define WPObject_wpQueryIcon(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryIcon) \
	(somSelf))
#define _wpQueryIcon WPObject_wpQueryIcon

/*
 * New Method: wpQueryIconData
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryIconData(WPObject *somSelf,
		PICONINFO pIconInfo);
#pragma linkage(somTP_WPObject_wpQueryIconData, system)
typedef somTP_WPObject_wpQueryIconData *somTD_WPObject_wpQueryIconData;
#define somMD_WPObject_wpQueryIconData "----"
#define WPObject_wpQueryIconData(somSelf,pIconInfo) \
    (SOM_Resolve(somSelf, WPObject, wpQueryIconData) \
	(somSelf,pIconInfo))
#define _wpQueryIconData WPObject_wpQueryIconData

/*
 * New Method: wpQueryMinWindow
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryMinWindow(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryMinWindow, system)
typedef somTP_WPObject_wpQueryMinWindow *somTD_WPObject_wpQueryMinWindow;
#define somMD_WPObject_wpQueryMinWindow "----"
#define WPObject_wpQueryMinWindow(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryMinWindow) \
	(somSelf))
#define _wpQueryMinWindow WPObject_wpQueryMinWindow

/*
 * New Method: wpQueryNameClashOptions
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryNameClashOptions(WPObject *somSelf,
		ULONG menuID);
#pragma linkage(somTP_WPObject_wpQueryNameClashOptions, system)
typedef somTP_WPObject_wpQueryNameClashOptions *somTD_WPObject_wpQueryNameClashOptions;
#define somMD_WPObject_wpQueryNameClashOptions "----"
#define WPObject_wpQueryNameClashOptions(somSelf,menuID) \
    (SOM_Resolve(somSelf, WPObject, wpQueryNameClashOptions) \
	(somSelf,menuID))
#define _wpQueryNameClashOptions WPObject_wpQueryNameClashOptions

/*
 * New Method: wpQueryStyle
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryStyle(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryStyle, system)
typedef somTP_WPObject_wpQueryStyle *somTD_WPObject_wpQueryStyle;
#define somMD_WPObject_wpQueryStyle "----"
#define WPObject_wpQueryStyle(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryStyle) \
	(somSelf))
#define _wpQueryStyle WPObject_wpQueryStyle

/*
 * New Method: wpSetTaskRec
 */
typedef BOOL32    SOMLINK somTP_WPObject_wpSetTaskRec(WPObject *somSelf,
		PTASKREC pNew,
		PTASKREC pOld);
#pragma linkage(somTP_WPObject_wpSetTaskRec, system)
typedef somTP_WPObject_wpSetTaskRec *somTD_WPObject_wpSetTaskRec;
#define somMD_WPObject_wpSetTaskRec "----"
#define WPObject_wpSetTaskRec(somSelf,pNew,pOld) \
    (SOM_Resolve(somSelf, WPObject, wpSetTaskRec) \
	(somSelf,pNew,pOld))
#define _wpSetTaskRec WPObject_wpSetTaskRec

/*
 * New Method: wpFindTaskRec
 */
typedef PTASKREC    SOMLINK somTP_WPObject_wpFindTaskRec(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpFindTaskRec, system)
typedef somTP_WPObject_wpFindTaskRec *somTD_WPObject_wpFindTaskRec;
#define somMD_WPObject_wpFindTaskRec "----"
#define WPObject_wpFindTaskRec(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpFindTaskRec) \
	(somSelf))
#define _wpFindTaskRec WPObject_wpFindTaskRec

/*
 * New Method: wpQueryTitle
 */
typedef PSZ    SOMLINK somTP_WPObject_wpQueryTitle(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryTitle, system)
typedef somTP_WPObject_wpQueryTitle *somTD_WPObject_wpQueryTitle;
#define somMD_WPObject_wpQueryTitle "----"
#define WPObject_wpQueryTitle(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryTitle) \
	(somSelf))
#define _wpQueryTitle WPObject_wpQueryTitle

/*
 * New Method: wpRegisterView
 */
typedef BOOL    SOMLINK somTP_WPObject_wpRegisterView(WPObject *somSelf,
		HWND hwndFrame,
		PSZ pszViewTitle);
#pragma linkage(somTP_WPObject_wpRegisterView, system)
typedef somTP_WPObject_wpRegisterView *somTD_WPObject_wpRegisterView;
#define somMD_WPObject_wpRegisterView "----"
#define WPObject_wpRegisterView(somSelf,hwndFrame,pszViewTitle) \
    (SOM_Resolve(somSelf, WPObject, wpRegisterView) \
	(somSelf,hwndFrame,pszViewTitle))
#define _wpRegisterView WPObject_wpRegisterView

/*
 * New Method: wpReleaseObjectMutexSem
 */
typedef ULONG    SOMLINK somTP_WPObject_wpReleaseObjectMutexSem(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpReleaseObjectMutexSem, system)
typedef somTP_WPObject_wpReleaseObjectMutexSem *somTD_WPObject_wpReleaseObjectMutexSem;
#define somMD_WPObject_wpReleaseObjectMutexSem "----"
#define WPObject_wpReleaseObjectMutexSem(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpReleaseObjectMutexSem) \
	(somSelf))
#define _wpReleaseObjectMutexSem WPObject_wpReleaseObjectMutexSem

/*
 * New Method: wpRender
 */
typedef MRESULT    SOMLINK somTP_WPObject_wpRender(WPObject *somSelf,
		PDRAGTRANSFER pdxfer);
#pragma linkage(somTP_WPObject_wpRender, system)
typedef somTP_WPObject_wpRender *somTD_WPObject_wpRender;
#define somMD_WPObject_wpRender "----"
#define WPObject_wpRender(somSelf,pdxfer) \
    (SOM_Resolve(somSelf, WPObject, wpRender) \
	(somSelf,pdxfer))
#define _wpRender WPObject_wpRender

/*
 * New Method: wpRenderComplete
 */
typedef MRESULT    SOMLINK somTP_WPObject_wpRenderComplete(WPObject *somSelf,
		PDRAGTRANSFER pdxfer,
		ULONG ulResult);
#pragma linkage(somTP_WPObject_wpRenderComplete, system)
typedef somTP_WPObject_wpRenderComplete *somTD_WPObject_wpRenderComplete;
#define somMD_WPObject_wpRenderComplete "----"
#define WPObject_wpRenderComplete(somSelf,pdxfer,ulResult) \
    (SOM_Resolve(somSelf, WPObject, wpRenderComplete) \
	(somSelf,pdxfer,ulResult))
#define _wpRenderComplete WPObject_wpRenderComplete

/*
 * New Method: wpReplaceObject
 */
typedef BOOL32    SOMLINK somTP_WPObject_wpReplaceObject(WPObject *somSelf,
		WPObject *targetObject,
		BOOL32 fMove);
#pragma linkage(somTP_WPObject_wpReplaceObject, system)
typedef somTP_WPObject_wpReplaceObject *somTD_WPObject_wpReplaceObject;
#define somMD_WPObject_wpReplaceObject "----"
#define WPObject_wpReplaceObject(somSelf,targetObject,fMove) \
    (SOM_Resolve(somSelf, WPObject, wpReplaceObject) \
	(somSelf,targetObject,fMove))
#define _wpReplaceObject WPObject_wpReplaceObject

/*
 * New Method: wpRequestObjectMutexSem
 */
typedef ULONG    SOMLINK somTP_WPObject_wpRequestObjectMutexSem(WPObject *somSelf,
		ULONG ulTimeout);
#pragma linkage(somTP_WPObject_wpRequestObjectMutexSem, system)
typedef somTP_WPObject_wpRequestObjectMutexSem *somTD_WPObject_wpRequestObjectMutexSem;
#define somMD_WPObject_wpRequestObjectMutexSem "----"
#define WPObject_wpRequestObjectMutexSem(somSelf,ulTimeout) \
    (SOM_Resolve(somSelf, WPObject, wpRequestObjectMutexSem) \
	(somSelf,ulTimeout))
#define _wpRequestObjectMutexSem WPObject_wpRequestObjectMutexSem

/*
 * New Method: wpRestore
 */
typedef BOOL    SOMLINK somTP_WPObject_wpRestore(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpRestore, system)
typedef somTP_WPObject_wpRestore *somTD_WPObject_wpRestore;
#define somMD_WPObject_wpRestore "----"
#define WPObject_wpRestore(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpRestore) \
	(somSelf))
#define _wpRestore WPObject_wpRestore

/*
 * New Method: wpRestoreData
 */
typedef BOOL    SOMLINK somTP_WPObject_wpRestoreData(WPObject *somSelf,
		PSZ pszClass,
		ULONG ulKey,
		PBYTE pValue,
		PULONG pcbValue);
#pragma linkage(somTP_WPObject_wpRestoreData, system)
typedef somTP_WPObject_wpRestoreData *somTD_WPObject_wpRestoreData;
#define somMD_WPObject_wpRestoreData "----"
#define WPObject_wpRestoreData(somSelf,pszClass,ulKey,pValue,pcbValue) \
    (SOM_Resolve(somSelf, WPObject, wpRestoreData) \
	(somSelf,pszClass,ulKey,pValue,pcbValue))
#define _wpRestoreData WPObject_wpRestoreData

/*
 * New Method: wpRestoreLong
 */
typedef BOOL    SOMLINK somTP_WPObject_wpRestoreLong(WPObject *somSelf,
		PSZ pszClass,
		ULONG ulKey,
		PULONG pulValue);
#pragma linkage(somTP_WPObject_wpRestoreLong, system)
typedef somTP_WPObject_wpRestoreLong *somTD_WPObject_wpRestoreLong;
#define somMD_WPObject_wpRestoreLong "----"
#define WPObject_wpRestoreLong(somSelf,pszClass,ulKey,pulValue) \
    (SOM_Resolve(somSelf, WPObject, wpRestoreLong) \
	(somSelf,pszClass,ulKey,pulValue))
#define _wpRestoreLong WPObject_wpRestoreLong

/*
 * New Method: wpRestoreState
 */
typedef BOOL    SOMLINK somTP_WPObject_wpRestoreState(WPObject *somSelf,
		ULONG ulReserved);
#pragma linkage(somTP_WPObject_wpRestoreState, system)
typedef somTP_WPObject_wpRestoreState *somTD_WPObject_wpRestoreState;
#define somMD_WPObject_wpRestoreState "----"
#define WPObject_wpRestoreState(somSelf,ulReserved) \
    (SOM_Resolve(somSelf, WPObject, wpRestoreState) \
	(somSelf,ulReserved))
#define _wpRestoreState WPObject_wpRestoreState

/*
 * New Method: wpRestoreString
 */
typedef BOOL    SOMLINK somTP_WPObject_wpRestoreString(WPObject *somSelf,
		PSZ pszClass,
		ULONG ulKey,
		PSZ pszValue,
		PULONG pcbValue);
#pragma linkage(somTP_WPObject_wpRestoreString, system)
typedef somTP_WPObject_wpRestoreString *somTD_WPObject_wpRestoreString;
#define somMD_WPObject_wpRestoreString "----"
#define WPObject_wpRestoreString(somSelf,pszClass,ulKey,pszValue,pcbValue) \
    (SOM_Resolve(somSelf, WPObject, wpRestoreString) \
	(somSelf,pszClass,ulKey,pszValue,pcbValue))
#define _wpRestoreString WPObject_wpRestoreString

/*
 * New Method: wpSaveData
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSaveData(WPObject *somSelf,
		PSZ pszClass,
		ULONG ulKey,
		PBYTE pValue,
		ULONG cbValue);
#pragma linkage(somTP_WPObject_wpSaveData, system)
typedef somTP_WPObject_wpSaveData *somTD_WPObject_wpSaveData;
#define somMD_WPObject_wpSaveData "----"
#define WPObject_wpSaveData(somSelf,pszClass,ulKey,pValue,cbValue) \
    (SOM_Resolve(somSelf, WPObject, wpSaveData) \
	(somSelf,pszClass,ulKey,pValue,cbValue))
#define _wpSaveData WPObject_wpSaveData

/*
 * New Method: wpSaveImmediate
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSaveImmediate(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpSaveImmediate, system)
typedef somTP_WPObject_wpSaveImmediate *somTD_WPObject_wpSaveImmediate;
#define somMD_WPObject_wpSaveImmediate "----"
#define WPObject_wpSaveImmediate(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpSaveImmediate) \
	(somSelf))
#define _wpSaveImmediate WPObject_wpSaveImmediate

/*
 * New Method: wpSaveDeferred
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSaveDeferred(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpSaveDeferred, system)
typedef somTP_WPObject_wpSaveDeferred *somTD_WPObject_wpSaveDeferred;
#define somMD_WPObject_wpSaveDeferred "----"
#define WPObject_wpSaveDeferred(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpSaveDeferred) \
	(somSelf))
#define _wpSaveDeferred WPObject_wpSaveDeferred

/*
 * New Method: wpSaveLong
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSaveLong(WPObject *somSelf,
		PSZ pszClass,
		ULONG ulKey,
		ULONG ulValue);
#pragma linkage(somTP_WPObject_wpSaveLong, system)
typedef somTP_WPObject_wpSaveLong *somTD_WPObject_wpSaveLong;
#define somMD_WPObject_wpSaveLong "----"
#define WPObject_wpSaveLong(somSelf,pszClass,ulKey,ulValue) \
    (SOM_Resolve(somSelf, WPObject, wpSaveLong) \
	(somSelf,pszClass,ulKey,ulValue))
#define _wpSaveLong WPObject_wpSaveLong

/*
 * New Method: wpSaveState
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSaveState(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpSaveState, system)
typedef somTP_WPObject_wpSaveState *somTD_WPObject_wpSaveState;
#define somMD_WPObject_wpSaveState "----"
#define WPObject_wpSaveState(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpSaveState) \
	(somSelf))
#define _wpSaveState WPObject_wpSaveState

/*
 * New Method: wpSaveString
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSaveString(WPObject *somSelf,
		PSZ pszClass,
		ULONG ulKey,
		PSZ pszValue);
#pragma linkage(somTP_WPObject_wpSaveString, system)
typedef somTP_WPObject_wpSaveString *somTD_WPObject_wpSaveString;
#define somMD_WPObject_wpSaveString "----"
#define WPObject_wpSaveString(somSelf,pszClass,ulKey,pszValue) \
    (SOM_Resolve(somSelf, WPObject, wpSaveString) \
	(somSelf,pszClass,ulKey,pszValue))
#define _wpSaveString WPObject_wpSaveString

/*
 * New Method: wpScanSetupString
 */
typedef BOOL    SOMLINK somTP_WPObject_wpScanSetupString(WPObject *somSelf,
		PSZ pszSetupString,
		PSZ pszKey,
		PSZ pszValue,
		PULONG pcbValue);
#pragma linkage(somTP_WPObject_wpScanSetupString, system)
typedef somTP_WPObject_wpScanSetupString *somTD_WPObject_wpScanSetupString;
#define somMD_WPObject_wpScanSetupString "----"
#define WPObject_wpScanSetupString(somSelf,pszSetupString,pszKey,pszValue,pcbValue) \
    (SOM_Resolve(somSelf, WPObject, wpScanSetupString) \
	(somSelf,pszSetupString,pszKey,pszValue,pcbValue))
#define _wpScanSetupString WPObject_wpScanSetupString

/*
 * New Method: wpSetConcurrentView
 */
typedef VOID    SOMLINK somTP_WPObject_wpSetConcurrentView(WPObject *somSelf,
		ULONG ulCCView);
#pragma linkage(somTP_WPObject_wpSetConcurrentView, system)
typedef somTP_WPObject_wpSetConcurrentView *somTD_WPObject_wpSetConcurrentView;
#define somMD_WPObject_wpSetConcurrentView "----"
#define WPObject_wpSetConcurrentView(somSelf,ulCCView) \
    (SOM_Resolve(somSelf, WPObject, wpSetConcurrentView) \
	(somSelf,ulCCView))
#define _wpSetConcurrentView WPObject_wpSetConcurrentView

/*
 * New Method: wpSetButtonAppearance
 */
typedef VOID    SOMLINK somTP_WPObject_wpSetButtonAppearance(WPObject *somSelf,
		ULONG ulButtonType);
#pragma linkage(somTP_WPObject_wpSetButtonAppearance, system)
typedef somTP_WPObject_wpSetButtonAppearance *somTD_WPObject_wpSetButtonAppearance;
#define somMD_WPObject_wpSetButtonAppearance "----"
#define WPObject_wpSetButtonAppearance(somSelf,ulButtonType) \
    (SOM_Resolve(somSelf, WPObject, wpSetButtonAppearance) \
	(somSelf,ulButtonType))
#define _wpSetButtonAppearance WPObject_wpSetButtonAppearance

/*
 * New Method: wpSetDefaultHelp
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetDefaultHelp(WPObject *somSelf,
		ULONG HelpPanelId,
		PSZ HelpLibrary);
#pragma linkage(somTP_WPObject_wpSetDefaultHelp, system)
typedef somTP_WPObject_wpSetDefaultHelp *somTD_WPObject_wpSetDefaultHelp;
#define somMD_WPObject_wpSetDefaultHelp "----"
#define WPObject_wpSetDefaultHelp(somSelf,HelpPanelId,HelpLibrary) \
    (SOM_Resolve(somSelf, WPObject, wpSetDefaultHelp) \
	(somSelf,HelpPanelId,HelpLibrary))
#define _wpSetDefaultHelp WPObject_wpSetDefaultHelp

/*
 * New Method: wpSetDefaultView
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetDefaultView(WPObject *somSelf,
		ULONG ulView);
#pragma linkage(somTP_WPObject_wpSetDefaultView, system)
typedef somTP_WPObject_wpSetDefaultView *somTD_WPObject_wpSetDefaultView;
#define somMD_WPObject_wpSetDefaultView "----"
#define WPObject_wpSetDefaultView(somSelf,ulView) \
    (SOM_Resolve(somSelf, WPObject, wpSetDefaultView) \
	(somSelf,ulView))
#define _wpSetDefaultView WPObject_wpSetDefaultView

/*
 * New Method: wpSetError
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetError(WPObject *somSelf,
		ULONG ulErrorId);
#pragma linkage(somTP_WPObject_wpSetError, system)
typedef somTP_WPObject_wpSetError *somTD_WPObject_wpSetError;
#define somMD_WPObject_wpSetError "----"
#define WPObject_wpSetError(somSelf,ulErrorId) \
    (SOM_Resolve(somSelf, WPObject, wpSetError) \
	(somSelf,ulErrorId))
#define _wpSetError WPObject_wpSetError

/*
 * New Method: wpSetIcon
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetIcon(WPObject *somSelf,
		HPOINTER hptrNewIcon);
#pragma linkage(somTP_WPObject_wpSetIcon, system)
typedef somTP_WPObject_wpSetIcon *somTD_WPObject_wpSetIcon;
#define somMD_WPObject_wpSetIcon "----"
#define WPObject_wpSetIcon(somSelf,hptrNewIcon) \
    (SOM_Resolve(somSelf, WPObject, wpSetIcon) \
	(somSelf,hptrNewIcon))
#define _wpSetIcon WPObject_wpSetIcon

/*
 * New Method: wpSetIconData
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetIconData(WPObject *somSelf,
		PICONINFO pIconInfo);
#pragma linkage(somTP_WPObject_wpSetIconData, system)
typedef somTP_WPObject_wpSetIconData *somTD_WPObject_wpSetIconData;
#define somMD_WPObject_wpSetIconData "----"
#define WPObject_wpSetIconData(somSelf,pIconInfo) \
    (SOM_Resolve(somSelf, WPObject, wpSetIconData) \
	(somSelf,pIconInfo))
#define _wpSetIconData WPObject_wpSetIconData

/*
 * New Method: wpSetMinWindow
 */
typedef VOID    SOMLINK somTP_WPObject_wpSetMinWindow(WPObject *somSelf,
		ULONG ulMinWindow);
#pragma linkage(somTP_WPObject_wpSetMinWindow, system)
typedef somTP_WPObject_wpSetMinWindow *somTD_WPObject_wpSetMinWindow;
#define somMD_WPObject_wpSetMinWindow "----"
#define WPObject_wpSetMinWindow(somSelf,ulMinWindow) \
    (SOM_Resolve(somSelf, WPObject, wpSetMinWindow) \
	(somSelf,ulMinWindow))
#define _wpSetMinWindow WPObject_wpSetMinWindow

/*
 * New Method: wpSetStyle
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetStyle(WPObject *somSelf,
		ULONG ulNewStyle);
#pragma linkage(somTP_WPObject_wpSetStyle, system)
typedef somTP_WPObject_wpSetStyle *somTD_WPObject_wpSetStyle;
#define somMD_WPObject_wpSetStyle "----"
#define WPObject_wpSetStyle(somSelf,ulNewStyle) \
    (SOM_Resolve(somSelf, WPObject, wpSetStyle) \
	(somSelf,ulNewStyle))
#define _wpSetStyle WPObject_wpSetStyle

/*
 * New Method: wpModifyStyle
 */
typedef BOOL    SOMLINK somTP_WPObject_wpModifyStyle(WPObject *somSelf,
		ULONG ulStyleFlags,
		ULONG ulStyleMask);
#pragma linkage(somTP_WPObject_wpModifyStyle, system)
typedef somTP_WPObject_wpModifyStyle *somTD_WPObject_wpModifyStyle;
#define somMD_WPObject_wpModifyStyle "----"
#define WPObject_wpModifyStyle(somSelf,ulStyleFlags,ulStyleMask) \
    (SOM_Resolve(somSelf, WPObject, wpModifyStyle) \
	(somSelf,ulStyleFlags,ulStyleMask))
#define _wpModifyStyle WPObject_wpModifyStyle

/*
 * New Method: wpSetTitle
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetTitle(WPObject *somSelf,
		PSZ pszNewTitle);
#pragma linkage(somTP_WPObject_wpSetTitle, system)
typedef somTP_WPObject_wpSetTitle *somTD_WPObject_wpSetTitle;
#define somMD_WPObject_wpSetTitle "----"
#define WPObject_wpSetTitle(somSelf,pszNewTitle) \
    (SOM_Resolve(somSelf, WPObject, wpSetTitle) \
	(somSelf,pszNewTitle))
#define _wpSetTitle WPObject_wpSetTitle

/*
 * New Method: wpSetup
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSetup(WPObject *somSelf,
		PSZ pszSetupString);
#pragma linkage(somTP_WPObject_wpSetup, system)
typedef somTP_WPObject_wpSetup *somTD_WPObject_wpSetup;
#define somMD_WPObject_wpSetup "----"
#define WPObject_wpSetup(somSelf,pszSetupString) \
    (SOM_Resolve(somSelf, WPObject, wpSetup) \
	(somSelf,pszSetupString))
#define _wpSetup WPObject_wpSetup

/*
 * New Method: wpSwitchTo
 */
typedef BOOL    SOMLINK somTP_WPObject_wpSwitchTo(WPObject *somSelf,
		ULONG View);
#pragma linkage(somTP_WPObject_wpSwitchTo, system)
typedef somTP_WPObject_wpSwitchTo *somTD_WPObject_wpSwitchTo;
#define somMD_WPObject_wpSwitchTo "----"
#define WPObject_wpSwitchTo(somSelf,View) \
    (SOM_Resolve(somSelf, WPObject, wpSwitchTo) \
	(somSelf,View))
#define _wpSwitchTo WPObject_wpSwitchTo

/*
 * New Method: wpUnInitData
 */
typedef void    SOMLINK somTP_WPObject_wpUnInitData(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpUnInitData, system)
typedef somTP_WPObject_wpUnInitData *somTD_WPObject_wpUnInitData;
#define somMD_WPObject_wpUnInitData "----"
#define WPObject_wpUnInitData(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpUnInitData) \
	(somSelf))
#define _wpUnInitData WPObject_wpUnInitData

/*
 * New Method: wpViewObject
 */
typedef HWND    SOMLINK somTP_WPObject_wpViewObject(WPObject *somSelf,
		HWND hwndCnr,
		ULONG ulView,
		ULONG param);
#pragma linkage(somTP_WPObject_wpViewObject, system)
typedef somTP_WPObject_wpViewObject *somTD_WPObject_wpViewObject;
#define somMD_WPObject_wpViewObject "----"
#define WPObject_wpViewObject(somSelf,hwndCnr,ulView,param) \
    (SOM_Resolve(somSelf, WPObject, wpViewObject) \
	(somSelf,hwndCnr,ulView,param))
#define _wpViewObject WPObject_wpViewObject

/*
 * Direct call procedure
 */
typedef ULONG    SOMLINK somTP_WPObject_wpQueryTrueStyle(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryTrueStyle, system)
typedef somTP_WPObject_wpQueryTrueStyle *somTD_WPObject_wpQueryTrueStyle;
#define WPObject_wpQueryTrueStyle ((somTD_WPObject_wpQueryTrueStyle) WPObjectClassData.wpQueryTrueStyle)
#define _wpQueryTrueStyle WPObject_wpQueryTrueStyle

/*
 * New Method: wpQueryHandle
 */
typedef HOBJECT    SOMLINK somTP_WPObject_wpQueryHandle(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryHandle, system)
typedef somTP_WPObject_wpQueryHandle *somTD_WPObject_wpQueryHandle;
#define somMD_WPObject_wpQueryHandle "----"
#define WPObject_wpQueryHandle(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpQueryHandle) \
	(somSelf))
#define _wpQueryHandle WPObject_wpQueryHandle

/*
 * New Method: wpUnlockObject
 */
typedef BOOL    SOMLINK somTP_WPObject_wpUnlockObject(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpUnlockObject, system)
typedef somTP_WPObject_wpUnlockObject *somTD_WPObject_wpUnlockObject;
#define somMD_WPObject_wpUnlockObject "----"
#define WPObject_wpUnlockObject(somSelf) \
    (SOM_Resolve(somSelf, WPObject, wpUnlockObject) \
	(somSelf))
#define _wpUnlockObject WPObject_wpUnlockObject

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMAny * SOMLINK WPObjectNewClass(integer4 scemajorVersion,
		integer4 sceminorVersion);
#pragma linkage(WPObjectNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct WPObjectClassDataStructure {
	SOMAny *classObject;
	somMToken wpSetTitle;
	somMToken wpQueryTitle;
	somMToken wpSetStyle;
	somMToken wpQueryStyle;
	somMToken wpSetIcon;
	somMToken wpQueryIcon;
	somMToken wpSetContainer;
	somMToken wpQueryContainer;
	somMToken wpSetNextObj;
	somMToken wpQueryNextObj;
	somMToken wpSetDefaultView;
	somMToken wpQueryDefaultView;
	somMToken wpMakeDormant;
	somMToken wpSaveState;
	somMToken wpBeginSave;
	somMToken wpEndSave;
	somMToken wpSaveLong;
	somMToken wpSaveString;
	somMToken wpSaveData;
	somMToken wpAppendSaveData;
	somMToken wpRestoreState;
	somMToken wpBeginRestore;
	somMToken wpEndRestore;
	somMToken wpRestoreLong;
	somMToken wpRestoreString;
	somMToken wpRestoreData;
	somMToken wpExtractRestoreData;
	somMToken wpAllocMem;
	somMToken wpFreeMem;
	somMToken wpAddToObjUseList;
	somMToken wpDeleteFromObjUseList;
	somMToken wpFindUseItem;
	somMToken wpSwitchTo;
	somMToken withdrawn1;
	somMToken wpFilterPopupMenu;
	somMToken wpModifyPopupMenu;
	somMToken wpMenuItemSelected;
	somMToken wpFormatDragItem;
	somMToken wpDrop;
	somMToken wpDragOver;
	somMToken wpRender;
	somMToken wpEndConversation;
	somMToken withdrawn10;
	somMToken wpMakeObject;
	somMToken wpDestroyObject;
	somMToken wpFree;
	somMToken wpCopiedFromTemplate;
	somMToken wpAddSettingsPages;
	somMToken wpAddObjectGeneralPage;
	somMToken wpDisplayHelp;
	somMToken wpMenuItemHelpSelected;
	somMToken wpInsertSettingsPage;
	somMToken wpInsertPopupMenuItems;
	somMToken withdrawn5;
	somMToken withdrawn6;
	somMToken withdrawn4;
	somMToken withdrawn3;
	somMToken wpCnrInsertObject;
	somMToken wpCnrRemoveObject;
	somMToken wpInitData;
	somMToken wpUnInitData;
	somMToken wpSetup;
	somMToken wpScanSetupString;
	somMToken wpSaveImmediate;
	somMToken wpOpen;
	somMToken wpClose;
	somMToken wpHide;
	somMToken wpRestore;
	somMToken wpSetIconData;
	somMToken wpQueryIconData;
	somMToken wpQueryIconSaved;
	somMToken wpDelete;
	somMToken wpConfirmDelete;
	somMToken withdrawn2;
	somMToken withdrawn11;
	somMToken withdrawn7;
	somMToken wpRegisterView;
	somMToken wpIdentify;
	somMToken wpSetDefaultHelp;
	somMToken wpQueryDefaultHelp;
	somMToken wpDoesObjectMatch;
	somMToken wpCnrRefreshDetails;
	somMToken wpSetError;
	somMToken wpQueryError;
	somMToken wpDraggedOverObject;
	somMToken wpDroppedOnObject;
	somMToken wpSetDefaultIconPos;
	somMToken wpQueryDefaultIconPos;
	somMToken wpSetState;
	somMToken wpQueryState;
	somMToken wpSetObjectID;
	somMToken wpQueryObjectID;
	somMToken wpIsDeleteable;
	somMToken wpQueryHandle;
	somMToken wpSaveDeferred;
	somMToken wpAddObjectWindowPage;
	somMToken wpQueryConcurrentView;
	somMToken wpSetConcurrentView;
	somMToken wpQueryMinWindow;
	somMToken wpSetMinWindow;
	somMToken wpViewObject;
	somMToken wpQueryButtonAppearance;
	somMToken wpSetButtonAppearance;
	somMToken wpQueryConfirmations;
	somMToken wpCnrSetEmphasis;
	somMToken wpQueryCoreRecord;
	somMToken wpFindViewItem;
	somMToken wpCreateFromTemplate;
	somMethodProc *wpQueryTrueStyle;
	somMToken wpAssertObjectMutexSem;
	somMToken wpReleaseObjectMutexSem;
	somMToken wpRequestObjectMutexSem;
	somMToken wpCreateAnother;
	somMToken wpCreateShadowObject;
	somMToken wpCopyObject;
	somMToken wpMoveObject;
	somMToken wpLockObject;
	somMToken wpUnlockObject;
	somMToken wpIsLocked;
	somMToken wpRenderComplete;
	somMToken wpQueryDetailsData;
	somMToken wpPrintObject;
	somMToken wpQueryTaskRec;
	somMToken wpSetTaskRec;
	somMToken wpSnoozeNotify;
	somMToken wpModifyStyle;
	somMToken wpSetInsertState;
	somMToken wpFindTaskRec;
	somMToken wpAppendObject;
	somMToken wpReplaceObject;
	somMToken wpQueryNameClashOptions;
	somMToken wpConfirmObjectTitle;
	somDToken pobjNext;
	somMToken wpQueryContainerFlagPtr;
	somMToken wpAddWindowPosKey;
	somMToken wpDeleteWindowPosKeys;
	somMToken wpObjectInsertPreparation;
	somMToken wpCnrDeleteUseItem;
} WPObjectClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct WPObjectCClassDataStructure {
	somMethodTab *parentMtab;
	somDToken instanceDataToken;
} WPObjectCClassData;

#endif       /* wpobject_h */

/*
 * This file was generated by the SOM Compiler.
 * FileName: wpobject.h.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emith: 1.11
 */

#ifndef wpobject_mh
#define wpobject_mh


/*
 * Define the class name as an object type
 */
#ifndef M_WPObject
#define M_WPObject SOMAny
#endif

#define M_WPObject_MajorVersion 1
#define M_WPObject_MinorVersion 2

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define M_WPObjectNewClass wpobjc
#pragma linkage(wpobjc, system)
#define M_WPObjectClassData wpobjd
#define M_WPObjectCClassData wpobjx
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */
/*--------------Migration------------*/
#define M_WPObject_classObj M_WPObjectClassData.classObject
#define _M_WPObject M_WPObject_classObj

/*
 * New and Renew macros for M_WPObject
 */
#define _M_WPObjectNew() (_somNew(M_WPObjectClassData.classObject))
#define M_WPObjectNew() \
	( M_WPObjectClassData.classObject \
		? _M_WPObjectNew() \
		: ( M_WPObjectNewClass(M_WPObject_MajorVersion, M_WPObject_MinorVersion), _M_WPObjectNew() ) )
#define M_WPObjectRenew(buf) \
	( _somRenew(M_WPObjectClassData.classObject, buf) )

/*
 * Override method: somUninit
 */
#define M_WPObject_somUninit(somSelf) \
	SOMObject_somUninit(somSelf)

/*
 * Override method: somInitClass
 */
#define M_WPObject_somInitClass(somSelf,className,parentClass,instanceSize,maxStaticMethods,majorVersion,minorVersion) \
	SOMClass_somInitClass(somSelf,className,parentClass,instanceSize,maxStaticMethods,majorVersion,minorVersion)

/*
 * Override method: somNew
 */
#define M_WPObject_somNew(somSelf) \
	SOMClass_somNew(somSelf)

/*
 * Override method: somRenew
 */
#define M_WPObject_somRenew(somSelf,obj) \
	SOMClass_somRenew(somSelf,obj)

/*
 * New Method: wpclsCreateDefaultTemplates
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsCreateDefaultTemplates(M_WPObject *somSelf,
		WPObject *Folder);
#pragma linkage(somTP_M_WPObject_wpclsCreateDefaultTemplates, system)
typedef somTP_M_WPObject_wpclsCreateDefaultTemplates *somTD_M_WPObject_wpclsCreateDefaultTemplates;
#define somMD_M_WPObject_wpclsCreateDefaultTemplates "----"
#define M_WPObject_wpclsCreateDefaultTemplates(somSelf,Folder) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsCreateDefaultTemplates) \
	(somSelf,Folder))
#define _wpclsCreateDefaultTemplates M_WPObject_wpclsCreateDefaultTemplates

/*
 * New Method: wpclsInitData
 */
typedef void    SOMLINK somTP_M_WPObject_wpclsInitData(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsInitData, system)
typedef somTP_M_WPObject_wpclsInitData *somTD_M_WPObject_wpclsInitData;
#define somMD_M_WPObject_wpclsInitData "----"
#define M_WPObject_wpclsInitData(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsInitData) \
	(somSelf))
#define _wpclsInitData M_WPObject_wpclsInitData

/*
 * New Method: wpclsMakeAwake
 */
typedef WPObject *   SOMLINK somTP_M_WPObject_wpclsMakeAwake(M_WPObject *somSelf,
		PSZ pszTitle,
		ULONG ulStyle,
		HPOINTER hptrIcon,
		POBJDATA pObjData,
		WPFolder *Folder,
		ULONG ulUser);
#pragma linkage(somTP_M_WPObject_wpclsMakeAwake, system)
typedef somTP_M_WPObject_wpclsMakeAwake *somTD_M_WPObject_wpclsMakeAwake;
#define somMD_M_WPObject_wpclsMakeAwake "----"
#define M_WPObject_wpclsMakeAwake(somSelf,pszTitle,ulStyle,hptrIcon,pObjData,Folder,ulUser) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsMakeAwake) \
	(somSelf,pszTitle,ulStyle,hptrIcon,pObjData,Folder,ulUser))
#define _wpclsMakeAwake M_WPObject_wpclsMakeAwake

/*
 * New Method: wpclsNew
 */
typedef WPObject *   SOMLINK somTP_M_WPObject_wpclsNew(M_WPObject *somSelf,
		PSZ pszTitle,
		PSZ pszSetupEnv,
		WPFolder *Folder,
		BOOL fLock);
#pragma linkage(somTP_M_WPObject_wpclsNew, system)
typedef somTP_M_WPObject_wpclsNew *somTD_M_WPObject_wpclsNew;
#define somMD_M_WPObject_wpclsNew "----"
#define M_WPObject_wpclsNew(somSelf,pszTitle,pszSetupEnv,Folder,fLock) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsNew) \
	(somSelf,pszTitle,pszSetupEnv,Folder,fLock))
#define _wpclsNew M_WPObject_wpclsNew

/*
 * New Method: wpclsQueryDefaultHelp
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsQueryDefaultHelp(M_WPObject *somSelf,
		PULONG pHelpPanelId,
		PSZ pszHelpLibrary);
#pragma linkage(somTP_M_WPObject_wpclsQueryDefaultHelp, system)
typedef somTP_M_WPObject_wpclsQueryDefaultHelp *somTD_M_WPObject_wpclsQueryDefaultHelp;
#define somMD_M_WPObject_wpclsQueryDefaultHelp "----"
#define M_WPObject_wpclsQueryDefaultHelp(somSelf,pHelpPanelId,pszHelpLibrary) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryDefaultHelp) \
	(somSelf,pHelpPanelId,pszHelpLibrary))
#define _wpclsQueryDefaultHelp M_WPObject_wpclsQueryDefaultHelp

/*
 * New Method: wpclsQueryDefaultView
 */
typedef ULONG    SOMLINK somTP_M_WPObject_wpclsQueryDefaultView(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsQueryDefaultView, system)
typedef somTP_M_WPObject_wpclsQueryDefaultView *somTD_M_WPObject_wpclsQueryDefaultView;
#define somMD_M_WPObject_wpclsQueryDefaultView "----"
#define M_WPObject_wpclsQueryDefaultView(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryDefaultView) \
	(somSelf))
#define _wpclsQueryDefaultView M_WPObject_wpclsQueryDefaultView

/*
 * New Method: wpclsQueryDetails
 */
typedef PCLASSDETAILS    SOMLINK somTP_M_WPObject_wpclsQueryDetails(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsQueryDetails, system)
typedef somTP_M_WPObject_wpclsQueryDetails *somTD_M_WPObject_wpclsQueryDetails;
#define somMD_M_WPObject_wpclsQueryDetails "----"
#define M_WPObject_wpclsQueryDetails(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryDetails) \
	(somSelf))
#define _wpclsQueryDetails M_WPObject_wpclsQueryDetails

/*
 * New Method: wpclsQueryDetailsInfo
 */
typedef ULONG    SOMLINK somTP_M_WPObject_wpclsQueryDetailsInfo(M_WPObject *somSelf,
		PCLASSFIELDINFO *ppClassFieldInfo,
		PULONG pSize);
#pragma linkage(somTP_M_WPObject_wpclsQueryDetailsInfo, system)
typedef somTP_M_WPObject_wpclsQueryDetailsInfo *somTD_M_WPObject_wpclsQueryDetailsInfo;
#define somMD_M_WPObject_wpclsQueryDetailsInfo "----"
#define M_WPObject_wpclsQueryDetailsInfo(somSelf,ppClassFieldInfo,pSize) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryDetailsInfo) \
	(somSelf,ppClassFieldInfo,pSize))
#define _wpclsQueryDetailsInfo M_WPObject_wpclsQueryDetailsInfo

/*
 * New Method: wpclsQueryExtendedCriteria
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsQueryExtendedCriteria(M_WPObject *somSelf,
		PSZ pszName,
		ULONG ulSearchType,
		PVOID pvoidExtendedCriteria);
#pragma linkage(somTP_M_WPObject_wpclsQueryExtendedCriteria, system)
typedef somTP_M_WPObject_wpclsQueryExtendedCriteria *somTD_M_WPObject_wpclsQueryExtendedCriteria;
#define somMD_M_WPObject_wpclsQueryExtendedCriteria "----"
#define M_WPObject_wpclsQueryExtendedCriteria(somSelf,pszName,ulSearchType,pvoidExtendedCriteria) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryExtendedCriteria) \
	(somSelf,pszName,ulSearchType,pvoidExtendedCriteria))
#define _wpclsQueryExtendedCriteria M_WPObject_wpclsQueryExtendedCriteria

/*
 * New Method: wpclsQueryFolder
 */
typedef WPObject *   SOMLINK somTP_M_WPObject_wpclsQueryFolder(M_WPObject *somSelf,
		PSZ pszLocation,
		BOOL fLock);
#pragma linkage(somTP_M_WPObject_wpclsQueryFolder, system)
typedef somTP_M_WPObject_wpclsQueryFolder *somTD_M_WPObject_wpclsQueryFolder;
#define somMD_M_WPObject_wpclsQueryFolder "----"
#define M_WPObject_wpclsQueryFolder(somSelf,pszLocation,fLock) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryFolder) \
	(somSelf,pszLocation,fLock))
#define _wpclsQueryFolder M_WPObject_wpclsQueryFolder

/*
 * New Method: wpclsQueryIcon
 */
typedef HPOINTER    SOMLINK somTP_M_WPObject_wpclsQueryIcon(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsQueryIcon, system)
typedef somTP_M_WPObject_wpclsQueryIcon *somTD_M_WPObject_wpclsQueryIcon;
#define somMD_M_WPObject_wpclsQueryIcon "----"
#define M_WPObject_wpclsQueryIcon(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryIcon) \
	(somSelf))
#define _wpclsQueryIcon M_WPObject_wpclsQueryIcon

/*
 * New Method: wpclsQuerySearchInfo
 */
typedef VOID    SOMLINK somTP_M_WPObject_wpclsQuerySearchInfo(M_WPObject *somSelf,
		M_WPObject **ClassExtended,
		M_WPObject **ClassCreate,
		PULONG pulClassCriteriaSize);
#pragma linkage(somTP_M_WPObject_wpclsQuerySearchInfo, system)
typedef somTP_M_WPObject_wpclsQuerySearchInfo *somTD_M_WPObject_wpclsQuerySearchInfo;
#define somMD_M_WPObject_wpclsQuerySearchInfo "----"
#define M_WPObject_wpclsQuerySearchInfo(somSelf,ClassExtended,ClassCreate,pulClassCriteriaSize) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQuerySearchInfo) \
	(somSelf,ClassExtended,ClassCreate,pulClassCriteriaSize))
#define _wpclsQuerySearchInfo M_WPObject_wpclsQuerySearchInfo

/*
 * New Method: wpclsQueryStyle
 */
typedef ULONG    SOMLINK somTP_M_WPObject_wpclsQueryStyle(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsQueryStyle, system)
typedef somTP_M_WPObject_wpclsQueryStyle *somTD_M_WPObject_wpclsQueryStyle;
#define somMD_M_WPObject_wpclsQueryStyle "----"
#define M_WPObject_wpclsQueryStyle(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryStyle) \
	(somSelf))
#define _wpclsQueryStyle M_WPObject_wpclsQueryStyle

/*
 * New Method: wpclsQueryTitle
 */
typedef PSZ    SOMLINK somTP_M_WPObject_wpclsQueryTitle(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsQueryTitle, system)
typedef somTP_M_WPObject_wpclsQueryTitle *somTD_M_WPObject_wpclsQueryTitle;
#define somMD_M_WPObject_wpclsQueryTitle "----"
#define M_WPObject_wpclsQueryTitle(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryTitle) \
	(somSelf))
#define _wpclsQueryTitle M_WPObject_wpclsQueryTitle

/*
 * New Method: wpclsUnInitData
 */
typedef void    SOMLINK somTP_M_WPObject_wpclsUnInitData(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsUnInitData, system)
typedef somTP_M_WPObject_wpclsUnInitData *somTD_M_WPObject_wpclsUnInitData;
#define somMD_M_WPObject_wpclsUnInitData "----"
#define M_WPObject_wpclsUnInitData(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsUnInitData) \
	(somSelf))
#define _wpclsUnInitData M_WPObject_wpclsUnInitData

/*
 * New Method: wpclsFindObjectFirst
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsFindObjectFirst(M_WPObject *somSelf,
		PCLASS pClassList,
		PHFIND phFind,
		PSZ pszTitle,
		WPFolder *Folder,
		BOOL fSubfolders,
		PVOID pExtendedCriteria,
		POBJECT pBuffer,
		PULONG pCount);
#pragma linkage(somTP_M_WPObject_wpclsFindObjectFirst, system)
typedef somTP_M_WPObject_wpclsFindObjectFirst *somTD_M_WPObject_wpclsFindObjectFirst;
#define somMD_M_WPObject_wpclsFindObjectFirst "----"
#define M_WPObject_wpclsFindObjectFirst(somSelf,pClassList,phFind,pszTitle,Folder,fSubfolders,pExtendedCriteria,pBuffer,pCount) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsFindObjectFirst) \
	(somSelf,pClassList,phFind,pszTitle,Folder,fSubfolders,pExtendedCriteria,pBuffer,pCount))
#define _wpclsFindObjectFirst M_WPObject_wpclsFindObjectFirst

/*
 * New Method: wpclsFindObjectNext
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsFindObjectNext(M_WPObject *somSelf,
		HFIND hFind,
		POBJECT pBuffer,
		PULONG pCount);
#pragma linkage(somTP_M_WPObject_wpclsFindObjectNext, system)
typedef somTP_M_WPObject_wpclsFindObjectNext *somTD_M_WPObject_wpclsFindObjectNext;
#define somMD_M_WPObject_wpclsFindObjectNext "----"
#define M_WPObject_wpclsFindObjectNext(somSelf,hFind,pBuffer,pCount) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsFindObjectNext) \
	(somSelf,hFind,pBuffer,pCount))
#define _wpclsFindObjectNext M_WPObject_wpclsFindObjectNext

/*
 * New Method: wpclsFindObjectEnd
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsFindObjectEnd(M_WPObject *somSelf,
		HFIND hFind);
#pragma linkage(somTP_M_WPObject_wpclsFindObjectEnd, system)
typedef somTP_M_WPObject_wpclsFindObjectEnd *somTD_M_WPObject_wpclsFindObjectEnd;
#define somMD_M_WPObject_wpclsFindObjectEnd "----"
#define M_WPObject_wpclsFindObjectEnd(somSelf,hFind) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsFindObjectEnd) \
	(somSelf,hFind))
#define _wpclsFindObjectEnd M_WPObject_wpclsFindObjectEnd

/*
 * New Method: wpclsSetError
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsSetError(M_WPObject *somSelf,
		ULONG ulErrorId);
#pragma linkage(somTP_M_WPObject_wpclsSetError, system)
typedef somTP_M_WPObject_wpclsSetError *somTD_M_WPObject_wpclsSetError;
#define somMD_M_WPObject_wpclsSetError "----"
#define M_WPObject_wpclsSetError(somSelf,ulErrorId) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsSetError) \
	(somSelf,ulErrorId))
#define _wpclsSetError M_WPObject_wpclsSetError

/*
 * New Method: wpclsQueryError
 */
typedef ULONG    SOMLINK somTP_M_WPObject_wpclsQueryError(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsQueryError, system)
typedef somTP_M_WPObject_wpclsQueryError *somTD_M_WPObject_wpclsQueryError;
#define somMD_M_WPObject_wpclsQueryError "----"
#define M_WPObject_wpclsQueryError(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryError) \
	(somSelf))
#define _wpclsQueryError M_WPObject_wpclsQueryError

/*
 * New Method: wpclsQuerySettingsPageSize
 */
typedef BOOL    SOMLINK somTP_M_WPObject_wpclsQuerySettingsPageSize(M_WPObject *somSelf,
		PSIZEL pSizl);
#pragma linkage(somTP_M_WPObject_wpclsQuerySettingsPageSize, system)
typedef somTP_M_WPObject_wpclsQuerySettingsPageSize *somTD_M_WPObject_wpclsQuerySettingsPageSize;
#define somMD_M_WPObject_wpclsQuerySettingsPageSize "----"
#define M_WPObject_wpclsQuerySettingsPageSize(somSelf,pSizl) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQuerySettingsPageSize) \
	(somSelf,pSizl))
#define _wpclsQuerySettingsPageSize M_WPObject_wpclsQuerySettingsPageSize

/*
 * New Method: wpclsQueryIconData
 */
typedef ULONG    SOMLINK somTP_M_WPObject_wpclsQueryIconData(M_WPObject *somSelf,
		PICONINFO pIconInfo);
#pragma linkage(somTP_M_WPObject_wpclsQueryIconData, system)
typedef somTP_M_WPObject_wpclsQueryIconData *somTD_M_WPObject_wpclsQueryIconData;
#define somMD_M_WPObject_wpclsQueryIconData "----"
#define M_WPObject_wpclsQueryIconData(somSelf,pIconInfo) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryIconData) \
	(somSelf,pIconInfo))
#define _wpclsQueryIconData M_WPObject_wpclsQueryIconData

/*
 * New Method: wpclsQueryObject
 */
typedef WPObject *   SOMLINK somTP_M_WPObject_wpclsQueryObject(M_WPObject *somSelf,
		HOBJECT hObject);
#pragma linkage(somTP_M_WPObject_wpclsQueryObject, system)
typedef somTP_M_WPObject_wpclsQueryObject *somTD_M_WPObject_wpclsQueryObject;
#define somMD_M_WPObject_wpclsQueryObject "----"
#define M_WPObject_wpclsQueryObject(somSelf,hObject) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryObject) \
	(somSelf,hObject))
#define _wpclsQueryObject M_WPObject_wpclsQueryObject

/*
 * New Method: wpclsQueryButtonAppearance
 */
typedef ULONG    SOMLINK somTP_M_WPObject_wpclsQueryButtonAppearance(M_WPObject *somSelf);
#pragma linkage(somTP_M_WPObject_wpclsQueryButtonAppearance, system)
typedef somTP_M_WPObject_wpclsQueryButtonAppearance *somTD_M_WPObject_wpclsQueryButtonAppearance;
#define somMD_M_WPObject_wpclsQueryButtonAppearance "----"
#define M_WPObject_wpclsQueryButtonAppearance(somSelf) \
    (SOM_Resolve(somSelf, M_WPObject, wpclsQueryButtonAppearance) \
	(somSelf))
#define _wpclsQueryButtonAppearance M_WPObject_wpclsQueryButtonAppearance

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMAny * SOMLINK M_WPObjectNewClass(integer4 scemajorVersion,
		integer4 sceminorVersion);
#pragma linkage(M_WPObjectNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct M_WPObjectClassDataStructure {
	SOMAny *classObject;
	somMToken wpclsInitData;
	somMToken wpclsUnInitData;
	somMToken withdrawn8;
	somMToken wpclsMakeAwake;
	somMToken wpclsIncUsage;
	somMToken wpclsDecUsage;
	somMToken wpclsQueryTitle;
	somMToken wpclsQueryIcon;
	somMToken wpclsQueryDefaultHelp;
	somMToken wpclsQueryStyle;
	somMToken wpclsQueryDetailsInfo;
	somMToken wpclsQueryDefaultView;
	somMToken wpclsQueryDetails;
	somMToken wpclsQuerySearchInfo;
	somMToken wpclsQueryExtendedCriteria;
	somMToken wpclsCreateDefaultTemplates;
	somMToken withdrawn9;
	somMToken wpclsFindObjectFirst;
	somMToken wpclsFindObjectNext;
	somMToken wpclsFindObjectEnd;
	somMToken wpclsFindObjects;
	somMToken wpclsSetError;
	somMToken wpclsQueryError;
	somMToken wpclsQuerySettingsPageSize;
	somMToken wpclsSetSettingsPageSize;
	somMToken wpclsQueryIconData;
	somMToken wpclsSetIcon;
	somMToken wpclsSetIconData;
	somMToken wpclsQueryObject;
	somMToken wpclsObjectFromHandle;
	somMToken wpclsSaveDirtyObjects;
	somMToken wpclsLockDirtyList;
	somMToken wpclsUnlockDirtyList;
	somMToken wpclsLockRestartList;
	somMToken wpclsUnlockRestartList;
	somMToken wpclsQueryButtonAppearance;
	somMToken wpclsNew;
	somMToken wpclsQueryFolder;
	somMToken wpclsLockSleepyList;
	somMToken wpclsUnlockSleepyList;
	somMToken wpclsRemoveObjects;
	somMToken wpclsInsertMultipleObjects;
} M_WPObjectClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct M_WPObjectCClassDataStructure {
	somMethodTab *parentMtab;
	somDToken instanceDataToken;
} M_WPObjectCClassData;

#endif       /* wpobject_h */
